/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.com.google.common.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.signedness.qual.Signed;
import org.checkerframework.errorprone.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.errorprone.com.google.common.annotations.Beta;
import org.checkerframework.errorprone.com.google.common.annotations.GwtIncompatible;
import org.checkerframework.errorprone.com.google.common.base.Preconditions;
import org.checkerframework.errorprone.com.google.common.util.concurrent.ExecutionError;
import org.checkerframework.errorprone.com.google.common.util.concurrent.TimeLimiter;
import org.checkerframework.errorprone.com.google.common.util.concurrent.UncheckedExecutionException;
import org.checkerframework.errorprone.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;

@Beta
@CanIgnoreReturnValue
@GwtIncompatible
public final class FakeTimeLimiter
implements TimeLimiter {
    @Override
    public <T> T newProxy(T target, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Class<T> interfaceType, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long timeoutDuration, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        return target;
    }

    @Override
    public <T> T callWithTimeout(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Callable<T> callable, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long timeoutDuration, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness TimeUnit timeoutUnit) throws @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
        catch (Throwable e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public <T> T callUninterruptiblyWithTimeout(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Callable<T> callable, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long timeoutDuration, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness TimeUnit timeoutUnit) throws @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ExecutionException {
        return this.callWithTimeout(callable, timeoutDuration, timeoutUnit);
    }

    @Override
    public void runWithTimeout(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Runnable runnable, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long timeoutDuration, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
        catch (Throwable e) {
            throw new UncheckedExecutionException(e);
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Runnable runnable, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long timeoutDuration, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness TimeUnit timeoutUnit) {
        this.runWithTimeout(runnable, timeoutDuration, timeoutUnit);
    }
}

