/*
 * Decompiled with CFR 0.152.
 */
package net.bioclipse.biojava.domain;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.bioclipse.core.domain.BioObject;
import net.bioclipse.core.domain.ISequence;
import org.biojava.bio.seq.Sequence;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;

public class BiojavaSequence
extends BioObject
implements ISequence {
    Sequence sequence;

    public BiojavaSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public BiojavaSequence() {
    }

    public String getPlainSequence() {
        return this.sequence.seqString();
    }

    public String toFasta() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Namespace ns = RichObjectFactory.getDefaultNamespace();
        try {
            RichSequence.IOTools.writeFasta((OutputStream)os, (Sequence)this.sequence, (Namespace)ns);
            os.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Illegal BiojavaSequence", e);
        }
        return new String(os.toByteArray());
    }

    public Object getParsedResource() {
        return this.sequence;
    }

    public void setRichSequence(RichSequence richSequence) {
        this.sequence = richSequence;
    }

    public String getName() {
        return this.sequence != null ? this.sequence.getName() : "";
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }
}

