/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.service.impl;

import io.github.ecsoya.fabric.FabricQueryResponse;
import io.github.ecsoya.fabric.FabricResponse;
import io.github.ecsoya.fabric.bean.FabricBlock;
import io.github.ecsoya.fabric.bean.FabricHistory;
import io.github.ecsoya.fabric.bean.FabricObject;
import io.github.ecsoya.fabric.chaincode.FunctionType;
import io.github.ecsoya.fabric.config.FabricContext;
import io.github.ecsoya.fabric.service.IFabricObjectService;
import io.github.ecsoya.fabric.service.impl.AbstractFabricService;
import java.util.List;

public class FabricObjectServiceImpl
extends AbstractFabricService<FabricObject>
implements IFabricObjectService {
    public FabricObjectServiceImpl(FabricContext fabricContext) {
        super(fabricContext);
    }

    @Override
    public int extDelete(String key, String type) {
        return this.delete((String)key, (String)type).status;
    }

    @Override
    public FabricObject extGet(String key, String type) {
        return (FabricObject)this.get((String)key, (String)type).data;
    }

    @Override
    public FabricResponse delete(String key, String type) {
        if (key == null) {
            return FabricResponse.fail("Invalid argument: key");
        }
        if (type == null) {
            return FabricResponse.fail("Invalid argument: type");
        }
        return this.execute(this.newRequest(this.getFunction(FunctionType.FUNCTION_DELETE), type, key));
    }

    @Override
    public FabricQueryResponse<FabricObject> get(String key, String type) {
        if (key == null) {
            return FabricQueryResponse.failure("Invalid argument: key");
        }
        if (type == null) {
            return FabricQueryResponse.failure("Invalid argument: type");
        }
        return this.query(this.newQueryRequest(this.getGenericType(), this.getFunction(FunctionType.FUNCTION_GET), new String[]{type, key}));
    }

    @Override
    public FabricQueryResponse<List<FabricHistory>> history(String key, String type) {
        if (key == null) {
            return FabricQueryResponse.failure("Invalid argument: key");
        }
        if (type == null) {
            return FabricQueryResponse.failure("Invalid argument: type");
        }
        return this.queryMany(this.newQueryRequest(FabricHistory.class, this.getFunction(FunctionType.FUNCTION_HISTORY), new String[]{type, key}));
    }

    @Override
    public FabricQueryResponse<FabricBlock> block(String key, String type) {
        if (key == null) {
            return FabricQueryResponse.failure("Invalid argument: key");
        }
        if (type == null) {
            return FabricQueryResponse.failure("Invalid argument: type");
        }
        FabricQueryResponse<List<FabricHistory>> historyRes = this.history(key, type);
        if (historyRes.isOk(true)) {
            List histories = (List)historyRes.data;
            long blockHeight = 0L;
            FabricBlock result = null;
            for (FabricHistory fabricHistory : histories) {
                FabricBlock block = fabricHistory.getBlock();
                if (block == null) continue;
                if (result == null) {
                    result = block;
                    blockHeight = block.getBlockNumber();
                    continue;
                }
                if (block.getBlockNumber() >= blockHeight) continue;
                result = block;
            }
            if (result != null) {
                return FabricQueryResponse.success(result);
            }
            return FabricQueryResponse.failure("No block found for key: " + key);
        }
        return FabricQueryResponse.failure("Could not get block for key: " + key + " with error: " + historyRes.errorMsg);
    }

    @Override
    public List<FabricHistory> extHistory(String key, String type) {
        return (List)this.history((String)key, (String)type).data;
    }

    @Override
    public FabricBlock extBlock(String key, String type) {
        return (FabricBlock)this.block((String)key, (String)type).data;
    }
}

