/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.service.impl;

import io.github.ecsoya.fabric.FabricQueryRequest;
import io.github.ecsoya.fabric.FabricQueryResponse;
import io.github.ecsoya.fabric.FabricRequest;
import io.github.ecsoya.fabric.FabricResponse;
import io.github.ecsoya.fabric.config.FabricContext;
import io.github.ecsoya.fabric.service.IFabricBaseService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFabricBaseService
implements IFabricBaseService {
    private Logger logger = LoggerFactory.getLogger(AbstractFabricBaseService.class);
    protected FabricContext fabricContext;

    public AbstractFabricBaseService(FabricContext fabricContext) {
        this.fabricContext = fabricContext;
    }

    @Override
    public FabricResponse execute(FabricRequest request) {
        try {
            this.logger.debug("Fabric execute " + request.function + " ==>");
            FabricResponse response = this.fabricContext.execute(request);
            if (response.isOk()) {
                this.logger.debug("Fabric execute " + request.function + " <== OK");
            } else {
                this.logger.debug("Fabric execute " + request.function + " <== FAILED, " + response.errorMsg);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("Fabric execute " + request.function + " <==", (Throwable)e);
            return FabricResponse.fail(e.getMessage());
        }
    }

    @Override
    public <T> FabricQueryResponse<T> query(FabricQueryRequest<T> request) {
        try {
            this.logger.debug("Fabric query " + request.function + " ==>");
            FabricQueryResponse<T> response = this.fabricContext.query(request);
            if (response.isOk()) {
                this.logger.debug("Fabric query " + request.function + " <== OK");
            } else {
                this.logger.debug("Fabric query " + request.function + " <== FAILED, " + response.errorMsg);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("Fabric query " + request.function + " <==", (Throwable)e);
            return FabricQueryResponse.failure(e.getMessage());
        }
    }

    @Override
    public <T> FabricQueryResponse<List<T>> queryMany(FabricQueryRequest<T> request) {
        try {
            this.logger.debug("Fabric query many " + request.function + " ==>");
            FabricQueryResponse<List<T>> response = this.fabricContext.queryMany(request);
            if (response.isOk()) {
                this.logger.debug("Fabric query many " + request.function + " <== OK");
            } else {
                this.logger.debug("Fabric query many " + request.function + " <== FAILED, " + response.errorMsg);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("Fabric query many " + request.function + " <==", (Throwable)e);
            return FabricQueryResponse.failure(e.getMessage());
        }
    }
}

