/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.json;

import io.github.ecsoya.fabric.annotation.FabricJson;
import io.github.ecsoya.fabric.annotation.FabricValues;
import io.github.ecsoya.fabric.json.DefaultFabricJsonConverter;
import io.github.ecsoya.fabric.json.IFabricJsonConverter;
import io.github.ecsoya.fabric.utils.AnnotationUtils;
import io.github.ecsoya.fabric.utils.FabricUtil;
import java.lang.reflect.AnnotatedElement;

public class FabricWrapper {
    private String key;
    private String type;
    private String value;

    public FabricWrapper(Object object) {
        if (object != null) {
            this.initialize(object);
        }
    }

    private void initialize(Object object) {
        Object values;
        AnnotatedElement valuesElement;
        Class<? extends IFabricJsonConverter> converterClass;
        if (object == null) {
            return;
        }
        this.key = FabricUtil.resolveFabricId(object);
        this.type = FabricUtil.resolveFabricType(object);
        IFabricJsonConverter converter = new DefaultFabricJsonConverter();
        FabricJson fabricJson = object.getClass().getAnnotation(FabricJson.class);
        if (fabricJson != null && (converterClass = fabricJson.converter()) != null) {
            try {
                converter = converterClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        this.value = (valuesElement = AnnotationUtils.getAnnotatedElement(object.getClass(), FabricValues.class)) != null ? ((values = AnnotationUtils.getValue(object, valuesElement, Object.class)) != null ? converter.toString(values) : "") : converter.toString(object);
    }

    public boolean isValid() {
        return this.key != null && this.type != null && this.value != null;
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FabricWrapper)) {
            return false;
        }
        FabricWrapper other = (FabricWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FabricWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "FabricWrapper(key=" + this.getKey() + ", type=" + this.getType() + ", value=" + this.getValue() + ")";
    }
}

