/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.gateway;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hyperledger.fabric.gateway.ContractException;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.Network;
import org.hyperledger.fabric.gateway.Transaction;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.gateway.impl.GatewayImpl;
import org.hyperledger.fabric.gateway.impl.NetworkImpl;
import org.hyperledger.fabric.gateway.impl.TimePeriod;
import org.hyperledger.fabric.gateway.impl.TransactionImpl;
import org.hyperledger.fabric.gateway.spi.CommitHandler;
import org.hyperledger.fabric.gateway.spi.CommitHandlerFactory;
import org.hyperledger.fabric.sdk.ChaincodeID;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.ServiceDiscovery;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.TransactionRequest;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.exception.ServiceDiscoveryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricTransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(FabricTransaction.class);
    private static final Logger logger = LoggerFactory.getLogger(FabricTransaction.class);
    private long ordererTimeout = 60L;
    private long proposalTimeout = 5L;
    private TransactionImpl delegate;
    private TimePeriod commitTimeout;
    private CommitHandlerFactory commitHandlerFactory;
    private NetworkImpl network;
    private Channel channel;
    private GatewayImpl gateway;
    private ContractImpl contract;
    private Map<String, byte[]> transientData;
    private Collection<Peer> endorsingPeers = null;

    public FabricTransaction(TransactionImpl delegate, ContractImpl contract) {
        this.delegate = delegate;
        this.contract = contract;
        this.network = contract.getNetwork();
        this.channel = this.network.getChannel();
        this.gateway = this.network.getGateway();
        this.commitHandlerFactory = this.gateway.getCommitHandlerFactory();
        this.commitTimeout = this.gateway.getCommitTimeout();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Transaction setTransient(Map<String, byte[]> transientData) {
        this.transientData = transientData;
        this.delegate.setTransient(transientData);
        return this;
    }

    public Transaction setCommitTimeout(long timeout, TimeUnit timeUnit) {
        this.commitTimeout = new TimePeriod(timeout, timeUnit);
        this.delegate.setCommitTimeout(timeout, timeUnit);
        return this;
    }

    public Transaction setEndorsingPeers(Collection<Peer> peers) {
        this.endorsingPeers = peers;
        this.delegate.setEndorsingPeers(peers);
        return this;
    }

    public byte[] submit(String ... args) throws ContractException, TimeoutException, InterruptedException {
        return this.delegate.submit(args);
    }

    public byte[] evaluate(String ... args) throws ContractException {
        return this.delegate.evaluate(args);
    }

    public String execute(String[] args) {
        try {
            TransactionProposalRequest request = this.newProposalRequest(args);
            Collection<ProposalResponse> proposalResponses = this.sendTransactionProposal(request);
            Collection<ProposalResponse> validResponses = this.validatePeerResponses(proposalResponses);
            ProposalResponse proposalResponse = validResponses.iterator().next();
            proposalResponse.getChaincodeActionResponsePayload();
            String transactionId = proposalResponse.getTransactionID();
            Channel.TransactionOptions transactionOptions = Channel.TransactionOptions.createTransactionOptions().nOfEvents(Channel.NOfEvents.createNoEvents());
            CommitHandler commitHandler = this.commitHandlerFactory.create(transactionId, (Network)this.network);
            commitHandler.startListening();
            try {
                this.channel.sendTransaction(validResponses, transactionOptions).get(this.getOrdererTimeout(), TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                commitHandler.cancelListening();
                throw e;
            }
            catch (Exception e) {
                commitHandler.cancelListening();
                throw new ContractException("Failed to send transaction to the orderer", (Throwable)e);
            }
            commitHandler.waitForEvents(this.commitTimeout.getTime(), this.commitTimeout.getTimeUnit());
            return transactionId;
        }
        catch (Exception e1) {
            throw new GatewayRuntimeException((Throwable)e1);
        }
    }

    private TransactionProposalRequest newProposalRequest(String[] args) {
        TransactionProposalRequest request = this.network.getGateway().getClient().newTransactionProposalRequest();
        this.configureRequest((TransactionRequest)request, args);
        if (this.transientData != null) {
            try {
                request.setTransientMap(this.transientData);
            }
            catch (InvalidArgumentException e) {
                throw new IllegalStateException(e);
            }
        }
        return request;
    }

    private void configureRequest(TransactionRequest request, String[] args) {
        request.setChaincodeID(this.getChaincodeId());
        request.setFcn(this.getName());
        request.setArgs(args);
        request.setProposalWaitTime(this.getProposalTimeout() * 1000L);
    }

    private ChaincodeID getChaincodeId() {
        return ChaincodeID.newBuilder().setName(this.contract.getChaincodeId()).build();
    }

    private Collection<ProposalResponse> sendTransactionProposal(TransactionProposalRequest request) throws InvalidArgumentException, ServiceDiscoveryException, ProposalException {
        if (this.endorsingPeers != null) {
            return this.channel.sendTransactionProposal(request, this.endorsingPeers);
        }
        if (this.network.getGateway().isDiscoveryEnabled()) {
            Channel.DiscoveryOptions discoveryOptions = Channel.DiscoveryOptions.createDiscoveryOptions().setEndorsementSelector(ServiceDiscovery.EndorsementSelector.ENDORSEMENT_SELECTION_RANDOM).setForceDiscovery(true);
            return this.channel.sendTransactionProposalToEndorsers(request, discoveryOptions);
        }
        return this.channel.sendTransactionProposal(request);
    }

    private Collection<ProposalResponse> validatePeerResponses(Collection<ProposalResponse> proposalResponses) throws ContractException {
        ArrayList<ProposalResponse> validResponses = new ArrayList<ProposalResponse>();
        ArrayList invalidResponseMsgs = new ArrayList();
        proposalResponses.forEach(response -> {
            String peerUrl;
            String string = peerUrl = response.getPeer() != null ? response.getPeer().getUrl() : "<unknown>";
            if (response.getStatus().equals((Object)ChaincodeResponse.Status.SUCCESS)) {
                log.debug(String.format("validatePeerResponses: valid response from peer %s", peerUrl));
                validResponses.add((ProposalResponse)response);
            } else {
                logger.warn(String.format("validatePeerResponses: invalid response from peer %s, message %s", peerUrl, response.getMessage()));
                invalidResponseMsgs.add(response.getMessage());
            }
        });
        if (validResponses.size() < 1) {
            String msg = String.format("No valid proposal responses received. %d peer error responses: %s", invalidResponseMsgs.size(), String.join((CharSequence)"; ", invalidResponseMsgs));
            logger.error(msg);
            throw new ContractException(msg);
        }
        return validResponses;
    }

    public long getOrdererTimeout() {
        return this.ordererTimeout;
    }

    public void setOrdererTimeout(long ordererTimeout) {
        this.ordererTimeout = ordererTimeout;
    }

    public long getProposalTimeout() {
        return this.proposalTimeout;
    }

    public void setProposalTimeout(long proposalTimeout) {
        this.proposalTimeout = proposalTimeout;
    }

    public String getTransactionId() {
        return this.delegate.getTransactionId();
    }

    public Transaction setCommitHandler(CommitHandlerFactory commitHandler) {
        return this.delegate.setCommitHandler(commitHandler);
    }
}

