/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.gateway;

import io.github.ecsoya.fabric.gateway.FabricTransaction;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.hyperledger.fabric.gateway.Contract;
import org.hyperledger.fabric.gateway.ContractEvent;
import org.hyperledger.fabric.gateway.ContractException;
import org.hyperledger.fabric.gateway.Transaction;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.gateway.impl.TransactionImpl;
import org.hyperledger.fabric.gateway.spi.Checkpointer;

public class FabricContract
implements Contract {
    private ContractImpl delegate;
    private long ordererTimeout = 60L;
    private long proposalTimeout = 5L;

    public FabricContract(ContractImpl delegate) {
        this.delegate = delegate;
    }

    public Transaction createTransaction(String name) {
        return this.delegate.createTransaction(name);
    }

    public String executeTransaction(String name, String ... args) throws ContractException, TimeoutException, InterruptedException {
        TransactionImpl tx = (TransactionImpl)this.delegate.createTransaction(name);
        FabricTransaction fabricTransaction = new FabricTransaction(tx, this.delegate);
        fabricTransaction.setOrdererTimeout(this.getOrdererTimeout());
        fabricTransaction.setProposalTimeout(this.getProposalTimeout());
        return fabricTransaction.execute(args);
    }

    public byte[] submitTransaction(String name, String ... args) throws ContractException, TimeoutException, InterruptedException {
        return this.delegate.submitTransaction(name, args);
    }

    public byte[] evaluateTransaction(String name, String ... args) throws ContractException {
        return this.delegate.evaluateTransaction(name, args);
    }

    public Consumer<ContractEvent> addContractListener(Consumer<ContractEvent> listener) {
        return this.delegate.addContractListener(listener);
    }

    public Consumer<ContractEvent> addContractListener(Consumer<ContractEvent> listener, String eventName) {
        return this.delegate.addContractListener(listener, eventName);
    }

    public Consumer<ContractEvent> addContractListener(Consumer<ContractEvent> listener, Pattern eventNamePattern) {
        return this.delegate.addContractListener(listener, eventNamePattern);
    }

    public Consumer<ContractEvent> addContractListener(Checkpointer checkpointer, Consumer<ContractEvent> listener) throws IOException {
        return this.delegate.addContractListener(checkpointer, listener);
    }

    public Consumer<ContractEvent> addContractListener(Checkpointer checkpointer, Consumer<ContractEvent> listener, String eventName) throws IOException {
        return this.delegate.addContractListener(checkpointer, listener, eventName);
    }

    public Consumer<ContractEvent> addContractListener(Checkpointer checkpointer, Consumer<ContractEvent> listener, Pattern eventNamePattern) throws IOException {
        return this.delegate.addContractListener(checkpointer, listener, eventNamePattern);
    }

    public Consumer<ContractEvent> addContractListener(long startBlock, Consumer<ContractEvent> listener) {
        return this.delegate.addContractListener(startBlock, listener);
    }

    public Consumer<ContractEvent> addContractListener(long startBlock, Consumer<ContractEvent> listener, String eventName) {
        return this.delegate.addContractListener(startBlock, listener, eventName);
    }

    public Consumer<ContractEvent> addContractListener(long startBlock, Consumer<ContractEvent> listener, Pattern eventNamePattern) {
        return this.delegate.addContractListener(startBlock, listener, eventNamePattern);
    }

    public void removeContractListener(Consumer<ContractEvent> listener) {
        this.delegate.removeContractListener(listener);
    }

    public long getOrdererTimeout() {
        return this.ordererTimeout;
    }

    public void setOrdererTimeout(long ordererTimeout) {
        this.ordererTimeout = ordererTimeout;
    }

    public long getProposalTimeout() {
        return this.proposalTimeout;
    }

    public void setProposalTimeout(long proposalTimeout) {
        this.proposalTimeout = proposalTimeout;
    }
}

