/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.config;

import com.google.protobuf.InvalidProtocolBufferException;
import io.github.ecsoya.fabric.FabricException;
import io.github.ecsoya.fabric.FabricQueryRequest;
import io.github.ecsoya.fabric.FabricQueryResponse;
import io.github.ecsoya.fabric.FabricRequest;
import io.github.ecsoya.fabric.FabricResponse;
import io.github.ecsoya.fabric.bean.FabricBlock;
import io.github.ecsoya.fabric.bean.FabricHistory;
import io.github.ecsoya.fabric.bean.FabricLedger;
import io.github.ecsoya.fabric.bean.FabricTransaction;
import io.github.ecsoya.fabric.bean.FabricTransactionRWSet;
import io.github.ecsoya.fabric.chaincode.FunctionType;
import io.github.ecsoya.fabric.config.FabricChaincodeFunctionProperties;
import io.github.ecsoya.fabric.config.FabricChaincodeProperties;
import io.github.ecsoya.fabric.config.FabricGatewayProperties;
import io.github.ecsoya.fabric.config.FabricProperties;
import io.github.ecsoya.fabric.config.FabricWalletProperties;
import io.github.ecsoya.fabric.gateway.FabricContract;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Hex;
import org.hyperledger.fabric.gateway.Gateway;
import org.hyperledger.fabric.gateway.Identities;
import org.hyperledger.fabric.gateway.Identity;
import org.hyperledger.fabric.gateway.Network;
import org.hyperledger.fabric.gateway.Wallet;
import org.hyperledger.fabric.gateway.Wallets;
import org.hyperledger.fabric.gateway.X509Identity;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.protos.peer.TransactionPackage;
import org.hyperledger.fabric.sdk.BlockInfo;
import org.hyperledger.fabric.sdk.BlockchainInfo;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.NetworkConfig;
import org.hyperledger.fabric.sdk.TransactionInfo;
import org.hyperledger.fabric.sdk.TxReadWriteSetInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricContext {
    private Logger logger = LoggerFactory.getLogger(FabricContext.class);
    private final FabricProperties properties;
    private Gateway.Builder builder;
    private Network network;
    private FabricContract contract;

    public FabricContext(FabricProperties properties) {
        this.properties = properties;
        if (properties == null) {
            properties = new FabricProperties();
        }
    }

    public FabricProperties getProperties() {
        return this.properties;
    }

    public String getFunction(FunctionType type) {
        if (type == null) {
            return null;
        }
        if (this.properties == null) {
            return type.getFunctionName();
        }
        FabricChaincodeProperties chaincode = this.properties.getChaincode();
        if (chaincode == null) {
            return type.getFunctionName();
        }
        FabricChaincodeFunctionProperties functions = chaincode.getFunctions();
        if (functions == null) {
            return type.getFunctionName();
        }
        switch (type) {
            case FUNCTION_CREATE: {
                return functions.getCreate();
            }
            case FUNCTION_UPDATE: {
                return functions.getUpdate();
            }
            case FUNCTION_COUNT: {
                return functions.getCount();
            }
            case FUNCTION_DELETE: {
                return functions.getDelete();
            }
            case FUNCTION_EXISTS: {
                return functions.getExists();
            }
            case FUNCTION_GET: {
                return functions.getGet();
            }
            case FUNCTION_HISTORY: {
                return functions.getHistory();
            }
            case FUNCTION_QUERY: {
                return functions.getQuery();
            }
        }
        return null;
    }

    @PostConstruct
    private void initialize() throws FabricException {
        this.logger.debug("Initialize Fabric Context");
        this.logger.debug("Initialize Fabric Context with properties: " + this.properties);
        String channel = this.properties.getChannel();
        if (channel == null || channel.equals("")) {
            throw new FabricException("Initialize fabric gateway failed with invalid 'channel' name. Please make sure the channel is configured corrected by 'spring.fabric.channel'.");
        }
        FabricChaincodeProperties chaincode = this.properties.getChaincode();
        if (chaincode == null || chaincode.getIdentify() == null || chaincode.getIdentify().equals("")) {
            throw new FabricException("Initialize fabric gateway failed with invalid 'chaincode' name. Please make sure the chaincode is configured corrected by 'spring.fabric.chaincode'.");
        }
        InputStream configFile = this.properties.getNetworkContents();
        if (configFile == null) {
            throw new FabricException("Network config file can not be loaded. Please make sure 'spring.fabric.network.path' is configured.");
        }
        NetworkConfig config = null;
        try {
            config = NetworkConfig.fromYamlStream((InputStream)configFile);
        }
        catch (Exception e) {
            throw new FabricException("Network config can not be loaded.", e);
        }
        if (config == null) {
            throw new FabricException("Network config can not be loaded. Please make sure 'spring.fabric.network.path' is correct.");
        }
        FabricGatewayProperties gatewayProps = this.properties.getGateway();
        FabricWalletProperties walletProps = gatewayProps.getWallet();
        String identityName = walletProps.getIdentity();
        if (identityName == null || identityName.equals("")) {
            identityName = "admin";
            this.logger.debug("Initialize Fabric Context: missing identity for wallet, and using default value: admin");
        }
        Wallet wallet = this.createWallet(config, walletProps);
        try {
            if (wallet == null || wallet.get(identityName) == null) {
                throw new FabricException("Initialize Wallet failed, there's no identity = '" + identityName + "' exists in wallet directory: " + walletProps.getFile());
            }
        }
        catch (IOException e1) {
            throw new FabricException("Initialize Wallet failed, there's no identity = '" + identityName + "' exists in wallet directory: " + walletProps.getFile());
        }
        this.logger.debug("Initialize Gateway... ");
        configFile = this.properties.getNetworkContents();
        try {
            this.builder = Gateway.createBuilder().identity(wallet, identityName).networkConfig(configFile);
            this.builder.commitTimeout(gatewayProps.getCommitTimeout(), TimeUnit.SECONDS);
            this.builder.discovery(gatewayProps.isDiscovery());
        }
        catch (IOException e) {
            throw new FabricException("Initialize Gateway failed", e);
        }
        Gateway gateway = this.builder.connect();
        this.logger.debug("Initialize Network... ");
        this.network = gateway.getNetwork(channel);
    }

    private Wallet createWallet(NetworkConfig networkConfig, FabricWalletProperties walletConfig) {
        Wallet wallet = this.newFileSystemWallet(walletConfig);
        if (wallet == null) {
            wallet = this.newInMemoryWallet(networkConfig, walletConfig);
        }
        return wallet;
    }

    private Wallet newFileSystemWallet(FabricWalletProperties config) {
        if (config == null || config.isMemory() || config.getFile() == null || config.getFile().equals("")) {
            return null;
        }
        try {
            return Wallets.newFileSystemWallet((Path)new File(config.getFile()).toPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    private Wallet newInMemoryWallet(NetworkConfig network, FabricWalletProperties walletProps) {
        Wallet wallet = Wallets.newInMemoryWallet();
        if (network != null) {
            Enrollment enrollment;
            NetworkConfig.UserInfo peerAdmin;
            NetworkConfig.OrgInfo client;
            String identityName = walletProps.getIdentity();
            if (identityName == null || identityName.equals("")) {
                identityName = "admin";
                this.logger.debug("Initialize Fabric Context: missing identity for wallet, and using default value: admin");
            }
            if ((client = network.getClientOrganization()) != null && (peerAdmin = client.getPeerAdmin()) != null && (enrollment = peerAdmin.getEnrollment()) != null) {
                try {
                    X509Identity admin = Identities.newX509Identity((String)peerAdmin.getMspId(), (Enrollment)enrollment);
                    wallet.put(identityName, (Identity)admin);
                }
                catch (Exception e) {
                    throw new FabricException("Initialize Wallet failed", e);
                }
                this.logger.debug("Initialize Wallet " + identityName);
            }
        }
        return wallet;
    }

    private FabricContract getContract() {
        if (this.contract == null) {
            if (this.network == null) {
                Gateway gateway = this.builder.connect();
                this.network = gateway.getNetwork(this.properties.getChannel());
            }
            this.contract = new FabricContract((ContractImpl)this.network.getContract(this.properties.getChaincode().getIdentify()));
            FabricGatewayProperties gatewayProps = this.properties.getGateway();
            if (gatewayProps != null) {
                this.contract.setOrdererTimeout(gatewayProps.getOrdererTimeout());
                this.contract.setProposalTimeout(gatewayProps.getProposalTimeout());
            }
        }
        return this.contract;
    }

    public <T> FabricQueryResponse<T> query(FabricQueryRequest<T> queryRequest) {
        if (queryRequest == null) {
            return FabricQueryResponse.failure("Query request can not be null.");
        }
        FabricContract contract = null;
        try {
            queryRequest.checkValidate();
            contract = this.getContract();
            byte[] payload = contract.evaluateTransaction(queryRequest.function, queryRequest.arguments);
            return FabricQueryResponse.create(payload, queryRequest.type);
        }
        catch (Exception e) {
            return FabricQueryResponse.failure(e.getMessage());
        }
    }

    public <T> FabricQueryResponse<List<T>> queryArray(Class<T> type, String function, String ... arguments) {
        try {
            FabricQueryRequest<T> request = new FabricQueryRequest<T>(type, function, arguments);
            return this.queryMany(request);
        }
        catch (Exception e) {
            return FabricQueryResponse.failure(e.getMessage());
        }
    }

    public <T> FabricQueryResponse<List<T>> queryMany(FabricQueryRequest<T> queryRequest) {
        if (queryRequest == null) {
            return FabricQueryResponse.failure("Query request can not be null.");
        }
        FabricContract contract = null;
        try {
            queryRequest.checkValidate();
            contract = this.getContract();
            byte[] payloads = contract.evaluateTransaction(queryRequest.function, queryRequest.arguments);
            FabricQueryResponse results = FabricQueryResponse.many(payloads, queryRequest.type);
            if (results.isOk(true) && FabricHistory.class == queryRequest.type) {
                ((List)results.data).stream().forEach(t -> {
                    String txid = ((FabricHistory)t).getTxId();
                    BlockInfo block = this.queryBlockInfo(txid);
                    ((FabricHistory)t).setBlockInfo(block);
                });
            }
            return results;
        }
        catch (Exception e) {
            return FabricQueryResponse.failure(e.getMessage());
        }
    }

    private BlockInfo queryBlockInfo(String txid) {
        if (txid == null) {
            return null;
        }
        try {
            if (this.network == null) {
                this.getContract();
            }
            Channel channel = this.network.getChannel();
            return channel.queryBlockByTransactionID(txid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public FabricResponse execute(FabricRequest request) {
        if (request == null) {
            return FabricResponse.fail("Request can not be null");
        }
        try {
            FabricContract contract = this.getContract();
            String result = contract.executeTransaction(request.function, request.arguments);
            return FabricResponse.ok().setTransactionId(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FabricResponse.fail(e.getMessage());
        }
    }

    public FabricQueryResponse<FabricLedger> queryBlockchainInfo() {
        try {
            if (this.network == null) {
                this.getContract();
            }
            Channel channel = this.network.getChannel();
            BlockchainInfo info = channel.queryBlockchainInfo();
            FabricLedger ledger = new FabricLedger();
            ledger.setChannel(channel.getName());
            ledger.setHeight(info.getHeight());
            ledger.setCurrentHash(Hex.encodeHexString((byte[])info.getCurrentBlockHash()));
            ledger.setPreviousHash(Hex.encodeHexString((byte[])info.getPreviousBlockHash()));
            ledger.setName(this.properties.getName());
            ledger.setOrgs(this.properties.getOrganizations());
            ledger.setChaincode(this.properties.getChaincode().getIdentify());
            ledger.setChaincodeName(this.properties.getChaincode().getName());
            ledger.setPeers(this.properties.getPeers());
            return FabricQueryResponse.success(ledger);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FabricQueryResponse.failure(e.getLocalizedMessage());
        }
    }

    public FabricQueryResponse<FabricBlock> queryBlockByNumber(long blockNumber) {
        try {
            if (this.network == null) {
                this.getContract();
            }
            Channel channel = this.network.getChannel();
            BlockInfo block = channel.queryBlockByNumber(blockNumber);
            return FabricQueryResponse.success(FabricBlock.create(block));
        }
        catch (Exception e) {
            return FabricQueryResponse.failure(e.getLocalizedMessage());
        }
    }

    public FabricQueryResponse<FabricBlock> queryBlockByTransactionID(String txId) {
        try {
            if (this.network == null) {
                this.getContract();
            }
            Channel channel = this.network.getChannel();
            BlockInfo block = channel.queryBlockByTransactionID(txId);
            return FabricQueryResponse.success(FabricBlock.create(block));
        }
        catch (Exception e) {
            return FabricQueryResponse.failure(e.getLocalizedMessage());
        }
    }

    public FabricQueryResponse<FabricBlock> queryBlockByHash(byte[] blockHash) {
        try {
            if (this.network == null) {
                this.getContract();
            }
            Channel channel = this.network.getChannel();
            BlockInfo block = channel.queryBlockByHash(blockHash);
            return FabricQueryResponse.success(FabricBlock.create(block));
        }
        catch (Exception e) {
            return FabricQueryResponse.failure(e.getLocalizedMessage());
        }
    }

    public FabricQueryResponse<List<FabricTransaction>> queryTransactions(long blockNumber) {
        try {
            if (this.network == null) {
                this.getContract();
            }
            Channel channel = this.network.getChannel();
            BlockInfo block = channel.queryBlockByNumber(blockNumber);
            ArrayList<FabricTransaction> transactions = new ArrayList<FabricTransaction>();
            if (block != null) {
                int envelopeCount = block.getEnvelopeCount();
                for (int i = 0; i < envelopeCount; ++i) {
                    BlockInfo.EnvelopeInfo envelope = block.getEnvelopeInfo(i);
                    String txId = envelope.getTransactionID();
                    FabricTransaction tx = new FabricTransaction();
                    tx.setIndex(i);
                    tx.setTxId(txId);
                    tx.setChannel(envelope.getChannelId());
                    BlockInfo.EnvelopeInfo.IdentitiesInfo creator = envelope.getCreator();
                    if (creator != null) {
                        tx.setCreator(creator.getMspid());
                    }
                    tx.setDate(envelope.getTimestamp());
                    BlockInfo.EnvelopeType type = envelope.getType();
                    if (type != null) {
                        tx.setType(type.name());
                    }
                    tx.setValidationCode(envelope.getValidationCode());
                    TransactionInfo transaction = channel.queryTransactionByID(txId);
                    TransactionPackage.TxValidationCode validationCode = transaction.getValidationCode();
                    if (validationCode != null) {
                        tx.setValidationCode(validationCode.getNumber());
                    }
                    transactions.add(tx);
                }
            }
            return FabricQueryResponse.success(transactions);
        }
        catch (Exception e) {
            return FabricQueryResponse.failure(e.getLocalizedMessage());
        }
    }

    public FabricQueryResponse<FabricTransactionRWSet> queryTransactionRWSet(String txId) {
        try {
            Channel channel;
            BlockInfo block;
            if (this.network == null) {
                this.getContract();
            }
            if ((block = (channel = this.network.getChannel()).queryBlockByTransactionID(txId)) == null) {
                return FabricQueryResponse.failure("Unable to query block from txId=" + txId);
            }
            BlockInfo.TransactionEnvelopeInfo envelopeInfo = null;
            for (BlockInfo.EnvelopeInfo info : block.getEnvelopeInfos()) {
                if (!info.getTransactionID().equals(txId) || !(info instanceof BlockInfo.TransactionEnvelopeInfo)) continue;
                envelopeInfo = (BlockInfo.TransactionEnvelopeInfo)info;
                break;
            }
            FabricTransactionRWSet rwSet = new FabricTransactionRWSet();
            if (envelopeInfo != null) {
                envelopeInfo.getTransactionActionInfos().forEach(action -> {
                    TxReadWriteSetInfo txReadWriteSet = action.getTxReadWriteSet();
                    txReadWriteSet.getNsRwsetInfos().forEach(info -> {
                        String namespace = info.getNamespace();
                        if ("lscc".equals(namespace)) {
                            return;
                        }
                        try {
                            rwSet.setWrites(info.getRwset().getWritesList());
                            rwSet.setReads(info.getRwset().getReadsList());
                        }
                        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                            // empty catch block
                        }
                    });
                });
            }
            return FabricQueryResponse.success(rwSet);
        }
        catch (Exception e) {
            return FabricQueryResponse.failure(e.getLocalizedMessage());
        }
    }

    public FabricQueryResponse<FabricTransaction> queryTransactionInfo(String txId) {
        try {
            Channel channel;
            BlockInfo block;
            if (this.network == null) {
                this.getContract();
            }
            if ((block = (channel = this.network.getChannel()).queryBlockByTransactionID(txId)) == null) {
                return FabricQueryResponse.failure("Unable to query block from txId=" + txId);
            }
            BlockInfo.TransactionEnvelopeInfo envelopeInfo = null;
            for (BlockInfo.EnvelopeInfo info : block.getEnvelopeInfos()) {
                if (!info.getTransactionID().equals(txId) || !(info instanceof BlockInfo.TransactionEnvelopeInfo)) continue;
                envelopeInfo = (BlockInfo.TransactionEnvelopeInfo)info;
                break;
            }
            FabricTransaction tx = new FabricTransaction();
            tx.setTxId(txId);
            tx.setChannel(envelopeInfo.getChannelId());
            BlockInfo.EnvelopeInfo.IdentitiesInfo creator = envelopeInfo.getCreator();
            if (creator != null) {
                String mspid = creator.getMspid();
                tx.setCreator(mspid);
            }
            tx.setDate(envelopeInfo.getTimestamp());
            BlockInfo.EnvelopeType type = envelopeInfo.getType();
            if (type != null) {
                tx.setType(type.name());
            }
            tx.setValidationCode(envelopeInfo.getValidationCode());
            TransactionInfo transaction = channel.queryTransactionByID(txId);
            TransactionPackage.TxValidationCode validationCode = transaction.getValidationCode();
            if (validationCode != null) {
                tx.setValidationCode(validationCode.getNumber());
            }
            return FabricQueryResponse.success(tx);
        }
        catch (Exception e) {
            return FabricQueryResponse.failure(e.getLocalizedMessage());
        }
    }
}

