/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.bean;

import com.google.protobuf.InvalidProtocolBufferException;
import io.github.ecsoya.fabric.bean.FabricIdentity;
import io.github.ecsoya.fabric.utils.FabricUtil;
import org.hyperledger.fabric.sdk.BlockInfo;

public class FabricBlock
extends FabricIdentity {
    private String channel;
    private int transactionCount;
    private String chaincode;
    private String currentTxId;
    private String currentTxTimestamp;
    private String currentHash;
    private String previousHash;

    public static FabricBlock create(BlockInfo blockInfo) {
        if (blockInfo == null) {
            return null;
        }
        FabricBlock block = new FabricBlock();
        block.setBlockNumber(blockInfo.getBlockNumber());
        try {
            block.setChannel(blockInfo.getChannelId());
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        block.setDataHash(FabricUtil.hashToString(blockInfo.getDataHash()));
        block.setTransactionCount(blockInfo.getTransactionCount());
        block.setPreviousHash(FabricUtil.hashToString(blockInfo.getPreviousHash()));
        return block;
    }

    public String getChannel() {
        return this.channel;
    }

    public int getTransactionCount() {
        return this.transactionCount;
    }

    public String getChaincode() {
        return this.chaincode;
    }

    public String getCurrentTxId() {
        return this.currentTxId;
    }

    public String getCurrentTxTimestamp() {
        return this.currentTxTimestamp;
    }

    public String getCurrentHash() {
        return this.currentHash;
    }

    public String getPreviousHash() {
        return this.previousHash;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setTransactionCount(int transactionCount) {
        this.transactionCount = transactionCount;
    }

    public void setChaincode(String chaincode) {
        this.chaincode = chaincode;
    }

    public void setCurrentTxId(String currentTxId) {
        this.currentTxId = currentTxId;
    }

    public void setCurrentTxTimestamp(String currentTxTimestamp) {
        this.currentTxTimestamp = currentTxTimestamp;
    }

    public void setCurrentHash(String currentHash) {
        this.currentHash = currentHash;
    }

    public void setPreviousHash(String previousHash) {
        this.previousHash = previousHash;
    }

    @Override
    public String toString() {
        return "FabricBlock(channel=" + this.getChannel() + ", transactionCount=" + this.getTransactionCount() + ", chaincode=" + this.getChaincode() + ", currentTxId=" + this.getCurrentTxId() + ", currentTxTimestamp=" + this.getCurrentTxTimestamp() + ", currentHash=" + this.getCurrentHash() + ", previousHash=" + this.getPreviousHash() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FabricBlock)) {
            return false;
        }
        FabricBlock other = (FabricBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        if (this.getTransactionCount() != other.getTransactionCount()) {
            return false;
        }
        String this$chaincode = this.getChaincode();
        String other$chaincode = other.getChaincode();
        if (this$chaincode == null ? other$chaincode != null : !this$chaincode.equals(other$chaincode)) {
            return false;
        }
        String this$currentTxId = this.getCurrentTxId();
        String other$currentTxId = other.getCurrentTxId();
        if (this$currentTxId == null ? other$currentTxId != null : !this$currentTxId.equals(other$currentTxId)) {
            return false;
        }
        String this$currentTxTimestamp = this.getCurrentTxTimestamp();
        String other$currentTxTimestamp = other.getCurrentTxTimestamp();
        if (this$currentTxTimestamp == null ? other$currentTxTimestamp != null : !this$currentTxTimestamp.equals(other$currentTxTimestamp)) {
            return false;
        }
        String this$currentHash = this.getCurrentHash();
        String other$currentHash = other.getCurrentHash();
        if (this$currentHash == null ? other$currentHash != null : !this$currentHash.equals(other$currentHash)) {
            return false;
        }
        String this$previousHash = this.getPreviousHash();
        String other$previousHash = other.getPreviousHash();
        return !(this$previousHash == null ? other$previousHash != null : !this$previousHash.equals(other$previousHash));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FabricBlock;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + this.getTransactionCount();
        String $chaincode = this.getChaincode();
        result = result * 59 + ($chaincode == null ? 43 : $chaincode.hashCode());
        String $currentTxId = this.getCurrentTxId();
        result = result * 59 + ($currentTxId == null ? 43 : $currentTxId.hashCode());
        String $currentTxTimestamp = this.getCurrentTxTimestamp();
        result = result * 59 + ($currentTxTimestamp == null ? 43 : $currentTxTimestamp.hashCode());
        String $currentHash = this.getCurrentHash();
        result = result * 59 + ($currentHash == null ? 43 : $currentHash.hashCode());
        String $previousHash = this.getPreviousHash();
        result = result * 59 + ($previousHash == null ? 43 : $previousHash.hashCode());
        return result;
    }
}

