/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric;

import org.hyperledger.fabric.sdk.BlockEvent;

public class FabricResponse {
    public static final int SUCCESS = 1;
    public static final int FAILURE = -505;
    public final int status;
    public final String errorMsg;
    private String transactionId;

    public FabricResponse(int status, String errorMsg) {
        this.status = status;
        this.errorMsg = errorMsg;
    }

    public boolean isOk() {
        return this.status == 1;
    }

    public boolean isOk(boolean all) {
        return this.isOk();
    }

    public FabricResponse setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public static FabricResponse fail(String errorMsg) {
        return new FabricResponse(-505, errorMsg);
    }

    public static FabricResponse ok() {
        return new FabricResponse(1, null);
    }

    public static FabricResponse create(BlockEvent.TransactionEvent event) {
        if (event == null) {
            return FabricResponse.fail("Invalid transaction event");
        }
        FabricResponse res = new FabricResponse(1, null);
        res.setTransactionId(event.getTransactionID());
        return res;
    }
}

