/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.explorer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="spring.fabric.explorer")
public class FabricExplorerProperties {
    private String title = "Fabric Explorer";
    private String logo = "img/explorer/camel.png";
    private String copyright = "Ecsoya (jin.liu@soyatec.com)";
    private String hyperledgerExplorerUrl = "";
    private String path = "/explorer";
    private Map<String, Object> map;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public Map<String, Object> toMap() {
        if (this.map == null) {
            this.map = new HashMap<String, Object>();
            this.map.put("title", this.title);
            this.map.put("logo", this.logo);
            this.map.put("copyright", this.copyright);
            this.map.put("hyperledgerExplorerUrl", this.hyperledgerExplorerUrl);
            this.map.put("path", this.getPath());
        }
        return this.map;
    }

    public String getHyperledgerExplorerUrl() {
        return this.hyperledgerExplorerUrl;
    }

    public void setHyperledgerExplorerUrl(String hyperledgerExplorerUrl) {
        this.hyperledgerExplorerUrl = hyperledgerExplorerUrl;
    }

    public String getPath() {
        if (this.path == null || this.path.equals("")) {
            return "";
        }
        if (this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
        if (this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return "FabricExplorerProperties [" + this.toMap() + "]";
    }
}

