/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.server.serializer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;

public class Oauth2AuthenticationSerializer
implements ObjectDeserializer {
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (type == OAuth2Authentication.class) {
            try {
                Object o = this.parse(parser);
                if (o == null) {
                    return null;
                }
                if (o instanceof OAuth2Authentication) {
                    return (T)o;
                }
                JSONObject jsonObject = (JSONObject)o;
                OAuth2Request request = this.parseOauth2RequestAuth2Request(jsonObject);
                Object autoType = jsonObject.get((Object)"userAuthentication");
                if (autoType != null) {
                    return (T)new OAuth2Authentication(request, (Authentication)jsonObject.getObject("userAuthentication", autoType.getClass()));
                }
                return (T)new OAuth2Authentication(request, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private OAuth2Request parseOauth2RequestAuth2Request(JSONObject jsonObject) {
        JSONObject json = (JSONObject)jsonObject.getObject("oAuth2Request", JSONObject.class);
        Map requestParameters = (Map)json.getObject("requestParameters", Map.class);
        String clientId = json.getString("clientId");
        String grantType = json.getString("grantType");
        String redirectUri = json.getString("redirectUri");
        Boolean approved = json.getBoolean("approved");
        Set responseTypes = (Set)json.getObject("responseTypes", (TypeReference)new TypeReference<Set<String>>(){});
        Set<String> scope = this.parseScopeSet(json);
        Set grantedAuthorities = (Set)json.getObject("authorities", (TypeReference)new TypeReference<Set<SimpleGrantedAuthority>>(){});
        Set resourceIds = (Set)json.getObject("resourceIds", (TypeReference)new TypeReference<Set<String>>(){});
        Map extensions = (Map)json.getObject("extensions", (TypeReference)new TypeReference<Map<String, Serializable>>(){});
        OAuth2Request request = new OAuth2Request(requestParameters, clientId, (Collection)grantedAuthorities, approved.booleanValue(), scope, resourceIds, redirectUri, responseTypes, extensions);
        TokenRequest tokenRequest = new TokenRequest(requestParameters, clientId, scope, grantType);
        request.refresh(tokenRequest);
        return request;
    }

    public int getFastMatchToken() {
        return 0;
    }

    private Object parse(DefaultJSONParser parse) {
        JSONObject object = new JSONObject(parse.lexer.isEnabled(Feature.OrderedField));
        Object parsedObject = parse.parseObject((Map)object);
        if (parsedObject instanceof JSONObject) {
            return parsedObject;
        }
        if (parsedObject instanceof OAuth2Authentication) {
            return parsedObject;
        }
        return parsedObject == null ? null : new JSONObject((Map)parsedObject);
    }

    private Set<String> parseScopeSet(JSONObject json) {
        JSONArray scopes = json.getJSONArray("scope");
        return scopes.stream().map(Object::toString).collect(Collectors.toSet());
    }
}

