/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.server.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.oauth2.common.DefaultExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStoreSerializationStrategy;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import plus.easydo.starter.oauth.core.model.CustomizeUserDetails;
import plus.easydo.starter.oauth.server.model.OauthCode;
import plus.easydo.starter.oauth.server.serializer.DefaultOauth2RefreshTokenSerializer;
import plus.easydo.starter.oauth.server.serializer.Oauth2AuthenticationSerializer;
import plus.easydo.starter.redis.configure.FastJson2JsonRedisSerializer;

public class FastJsonRedisTokenStoreSerializationStrategy<T>
extends FastJson2JsonRedisSerializer<T>
implements RedisTokenStoreSerializationStrategy {
    private static final ParserConfig config = new ParserConfig();

    public FastJsonRedisTokenStoreSerializationStrategy(Class<T> clazz) {
        super(clazz);
    }

    protected static void init() {
        config.setAutoTypeSupport(true);
        config.putDeserializer(DefaultOAuth2RefreshToken.class, (ObjectDeserializer)new DefaultOauth2RefreshTokenSerializer());
        config.putDeserializer(OAuth2Authentication.class, (ObjectDeserializer)new Oauth2AuthenticationSerializer());
        config.addAccept("club.gebilaoyu.cloud.oauth.");
        TypeUtils.addMapping((String)"plus.easydo.starter.oauth.core.model.CustomizeUserDetails", CustomizeUserDetails.class);
        TypeUtils.addMapping((String)"club.gebilaoyu.cloud.starter.model.OauthCode", OauthCode.class);
        config.addAccept("org.springframework.security.authentication.");
        TypeUtils.addMapping((String)"org.springframework.security.authentication.UsernamePasswordAuthenticationToken", UsernamePasswordAuthenticationToken.class);
        config.addAccept("org.springframework.security.oauth2.provider.");
        config.addAccept("org.springframework.security.oauth2.provider.client");
        TypeUtils.addMapping((String)"org.springframework.security.oauth2.provider.OAuth2Authentication", OAuth2Authentication.class);
        TypeUtils.addMapping((String)"org.springframework.security.oauth2.provider.client.BaseClientDetails", BaseClientDetails.class);
        config.addAccept("org.springframework.security.oauth2.common.");
        TypeUtils.addMapping((String)"org.springframework.security.oauth2.common.DefaultOAuth2AccessToken", DefaultOAuth2AccessToken.class);
        TypeUtils.addMapping((String)"org.springframework.security.oauth2.common.DefaultExpiringOAuth2RefreshToken", DefaultExpiringOAuth2RefreshToken.class);
        config.addAccept("org.springframework.security.web.authentication.preauth");
        TypeUtils.addMapping((String)"org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken", PreAuthenticatedAuthenticationToken.class);
    }

    public <T> T deserialize(byte[] bytes, Class<T> aClass) {
        Preconditions.checkArgument((aClass != null ? 1 : 0) != 0, (Object)"clazz can't be null");
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return (T)JSON.parseObject((String)new String(bytes, DEFAULT_CHARSET), aClass, (ParserConfig)config, (Feature[])new Feature[0]);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public String deserializeString(byte[] bytes) {
        return new String(bytes, DEFAULT_CHARSET);
    }

    public byte[] serialize(Object object) {
        return super.serializeObject(object);
    }

    public byte[] serialize(String data) {
        if (data == null || data.length() == 0) {
            return new byte[0];
        }
        return data.getBytes(StandardCharsets.UTF_8);
    }

    static {
        FastJsonRedisTokenStoreSerializationStrategy.init();
    }
}

