/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.server.configure;

import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import plus.easydo.starter.oauth.server.configure.ServerBeanConfig;
import plus.easydo.starter.oauth.server.handler.MyLogoutSuccessHandler;
import plus.easydo.starter.oauth.server.properties.Oauth2ServerProperties;

@Order(value=90)
@Configuration
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Qualifier
    @Resource
    private ServerBeanConfig serverBeanConfig;
    @Value(value="${security.oauth2.whitelist}")
    private List<String> whiteList;
    @Resource
    private UserDetailsService userDetailsService;

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(HttpSecurity http) throws Exception {
        Oauth2ServerProperties properties = this.serverBeanConfig.properties();
        ((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{properties.getLoginPath(), "/auth/authorize", "/oauth/authorize"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/static/**", "/*.html", "/**/*.html", "/**/*.css", "/**/*.js"})).permitAll().antMatchers((String[])this.whiteList.stream().distinct().toArray(String[]::new))).permitAll().anyRequest()).authenticated().and()).formLogin().loginPage(properties.getLoginPath()).loginProcessingUrl("/auth/authorize")).and()).logout().logoutSuccessHandler((LogoutSuccessHandler)new MyLogoutSuccessHandler()).logoutUrl("/logout");
        http.httpBasic().disable();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService).passwordEncoder(this.serverBeanConfig.getPasswordEncoder());
    }
}

