package plus.easydo.starter.oauth.server.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import plus.easydo.starter.oauth.core.properties.Oauth2Properties;


/**
 * 属性配置文件
 * @author yuzhanfeng
 */
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "security.oauth2.customize")
public class Oauth2ServerProperties implements Oauth2Properties {

    private String confirmAccessPath = "/custom/confirm_access";

    private String loginPath = "/login";

    private String oathTokenPrefix = "OAUTH2_TOKEN";

    private boolean enableFastJsonSerializer = false;

    private String oauthCodePrefix = "AuthorizationCode";

    private String codeClientPrefix = "ClientToAuthCode";

    private int oauthCodeLength = 12;

    private String confirmAccessHtmlPrefix = "oauth";

    private String loginHtml = "login";

    private String loginSubmitUrlKey = "loginSubmitUrl";

    private int accessTokenValiditySeconds = 72000;

    private int refreshTokenValiditySeconds = 259200;

    private boolean tokenInfoUser = true;

    private boolean tokenInfoAll = true;

    public String getConfirmAccessPath() {
        return confirmAccessPath;
    }

    public void setConfirmAccessPath(String confirmAccessPath) {
        this.confirmAccessPath = confirmAccessPath;
    }

    public String getLoginPath() {
        return loginPath;
    }

    public void setLoginPath(String loginPath) {
        this.loginPath = loginPath;
    }

    public String getOathTokenPrefix() {
        return oathTokenPrefix;
    }

    public void setOathTokenPrefix(String oathTokenPrefix) {
        this.oathTokenPrefix = oathTokenPrefix;
    }

    public boolean isEnableFastJsonSerializer() {
        return enableFastJsonSerializer;
    }

    public void setEnableFastJsonSerializer(boolean enableFastJsonSerializer) {
        this.enableFastJsonSerializer = enableFastJsonSerializer;
    }

    public String getOauthCodePrefix() {
        return oauthCodePrefix;
    }

    public void setOauthCodePrefix(String oauthCodePrefix) {
        this.oauthCodePrefix = oauthCodePrefix;
    }

    public String getCodeClientPrefix() {
        return codeClientPrefix;
    }

    public void setCodeClientPrefix(String codeClientPrefix) {
        this.codeClientPrefix = codeClientPrefix;
    }

    public int getOauthCodeLength() {
        return oauthCodeLength;
    }

    @Deprecated
    public void setOauthCodeLength(int oauthCodeLength) {
        this.oauthCodeLength = oauthCodeLength;
    }

    public String getConfirmAccessHtmlPrefix() {
        return confirmAccessHtmlPrefix;
    }

    public void setConfirmAccessHtmlPrefix(String confirmAccessHtmlPrefix) {
        this.confirmAccessHtmlPrefix = confirmAccessHtmlPrefix;
    }

    public String getLoginHtml() {
        return loginHtml;
    }

    public void setLoginHtml(String loginHtml) {
        this.loginHtml = loginHtml;
    }

    public String getLoginSubmitUrlKey() {
        return loginSubmitUrlKey;
    }

    public void setLoginSubmitUrlKey(String loginSubmitUrlKey) {
        this.loginSubmitUrlKey = loginSubmitUrlKey;
    }

    public int getAccessTokenValiditySeconds() {
        return accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(int accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    public int getRefreshTokenValiditySeconds() {
        return refreshTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public boolean isTokenInfoUser() {
        return tokenInfoUser;
    }

    public void setTokenInfoUser(boolean tokenInfoUser) {
        this.tokenInfoUser = tokenInfoUser;
    }

    public boolean isTokenInfoAll() {
        return tokenInfoAll;
    }

    public void setTokenInfoAll(boolean tokenInfoAll) {
        this.tokenInfoAll = tokenInfoAll;
    }
}
