/*
 * Decompiled with CFR 0.152.
 */
package pub.dtm.client.model.feign;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ServiceMessage {
    private String serviceName;
    private String groupName = "DEFAULT_GROUP";
    private List<String> cluster = new ArrayList<String>();
    private String path;

    public ServiceMessage(String serviceName, String path) {
        this.serviceName = serviceName;
        this.path = path;
    }

    public ServiceMessage(String serviceName, String groupName, List<String> cluster, String path) {
        this.serviceName = serviceName;
        this.groupName = groupName;
        this.cluster.addAll(cluster);
        this.path = path;
    }

    public String getPath() {
        if (StringUtils.startsWith((CharSequence)this.path, (CharSequence)"/")) {
            return this.path;
        }
        return "/" + this.path;
    }

    public String toString() {
        String _path = this.path;
        if (!StringUtils.startsWith((CharSequence)this.path, (CharSequence)"/")) {
            _path = "/" + this.path;
        }
        return this.serviceName + _path + "?groupName=" + this.groupName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<String> getCluster() {
        return this.cluster;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setCluster(List<String> cluster) {
        this.cluster = cluster;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceMessage)) {
            return false;
        }
        ServiceMessage other = (ServiceMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        List<String> this$cluster = this.getCluster();
        List<String> other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        List<String> $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public ServiceMessage() {
    }
}

