/*
 * MIT License
 *
 * Copyright (c) 2022 dtm-labs
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package pub.dtm.client.model.param;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import pub.dtm.client.constant.ParamFieldConstants;
import pub.dtm.client.enums.TransTypeEnum;

/**
 * Tcc Operator Param
 * @author horseLk
 */
@Data
@NoArgsConstructor
public class TccOperatorParam extends OperatorParam {
    /**
     * branch id
     */
    @JsonProperty(ParamFieldConstants.BRANCH_ID)
    private String branchId;

    /**
     * status
     */
    @JsonProperty(ParamFieldConstants.STATUS)
    private String status;

    /**
     * data
     */
    @JsonProperty(ParamFieldConstants.DATA)
    private String data;

    /**
     * branch confirm uri
     */
    @JsonProperty(ParamFieldConstants.CONFIRM)
    private String confirm;

    /**
     * branch cancel uri
     */
    @JsonProperty(ParamFieldConstants.CANCEL)
    private String cancel;


    public TccOperatorParam(String gid, TransTypeEnum transTypeEnum, String branchId, String status, String data,
                            String confirm, String cancel) {
        super(gid, transTypeEnum);
        setSubType(transTypeEnum.getValue());
        this.branchId = branchId;
        this.status = status;
        this.data = data;
        this.confirm = confirm;
        this.cancel = cancel;
    }
}
