/*
 * MIT License
 *
 * Copyright (c) 2022 dtm-labs
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package pub.dtm.client.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Transtype enum
 *
 * @author horseLk
 */
public enum TransTypeEnum {
    /**
     * tcc
     */
    TCC("tcc"),
    /**
     * xa
     */
    XA("xa"),
    /**
     * msg
     */
    MSG("msg"),
    /**
     * saga
     */
    SAGA("saga")
    ;

    TransTypeEnum(String value) {
        this.value = value;
    }

    /**
     * Trans type string
     */
    private final String value;

    public String getValue() {
        return this.value;
    }

    private static final Map<String, TransTypeEnum> EXIST = new HashMap<>();

    static {
        for (TransTypeEnum transType : TransTypeEnum.values()) {
            EXIST.put(transType.value, transType);
        }
    }

    public static TransTypeEnum parseString(String value) {
        return EXIST.get(value);
    }
}
