/*
 * Decompiled with CFR 0.152.
 */
package io.github.drewctaylor.maven.plugin.javapoet;

import com.squareup.javapoet.JavaFile;
import fj.F2;
import fj.F3;
import fj.P;
import fj.Semigroup;
import fj.Try;
import fj.TryEffect;
import fj.Unit;
import fj.data.HashMap;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Validation;
import java.io.File;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public final class JavaPoetMojo
extends AbstractMojo {
    @Parameter(alias="path", defaultValue="${project.basedir}/src/main/java/")
    private String path;
    @Parameter(alias="methods", required=true)
    private Map<String, String> methods;

    private static Validation<NonEmptyList<Exception>, File> directoryFor(String path) {
        return ((Validation)Try.f(() -> {
            File file = Paths.get(path, new String[0]).toFile();
            if (file.isFile()) {
                throw new Exception(String.format("The path exists and references a file '%s'.", path));
            }
            if (!file.exists() && !file.mkdirs()) {
                throw new Exception(String.format("The plugin could not create the directory '%s'.", path));
            }
            return file;
        })._1()).f().map(x$0 -> NonEmptyList.nel((Object)x$0, (Object[])new Exception[0]));
    }

    private static Validation<NonEmptyList<Exception>, List<JavaFile>> javaFileStreamListFor(HashMap<String, String> classNameMethodNameParameterMap) {
        String regexForIdentifier = "[\\p{Alpha}_$][\\p{Alpha}\\p{Digit}_$]*";
        String regex = String.format("((%s)(\\.%s)*)\\.(%s)", "[\\p{Alpha}_$][\\p{Alpha}\\p{Digit}_$]*", "[\\p{Alpha}_$][\\p{Alpha}\\p{Digit}_$]*", "[\\p{Alpha}_$][\\p{Alpha}\\p{Digit}_$]*");
        Pattern pattern = Pattern.compile(regex);
        boolean groupForClassName = true;
        int groupForMethodName = 4;
        F2 classNameMethodNameFor = (matcher, classNameMethodName) -> Option.iif((boolean)matcher.matches(), () -> P.p((Object)matcher.group(1), (Object)matcher.group(4))).toValidation((Object)NonEmptyList.nel((Object)new Exception(String.format("The plugin could not parse the method '%s'.", classNameMethodName)), (Object[])new Exception[0]));
        F3 javaFileListFor = (className, methodName, parameter) -> ((Validation)Try.f(() -> Class.forName(className).getMethod((String)methodName, String.class).invoke(null, parameter))._1()).map(object -> List.iterableList((Iterable)((Iterable)object))).f().map(x$0 -> NonEmptyList.nel((Object)x$0, (Object[])new Exception[0]));
        return Validation.sequence((Semigroup)Semigroup.nonEmptyListSemigroup(), (List)classNameMethodNameParameterMap.toList().map(p -> ((Validation)classNameMethodNameFor.f((Object)pattern.matcher((CharSequence)p._1()), p._1())).map(pInner -> pInner.append(p._2()))).map(validation -> validation.bind(p -> (Validation)javaFileListFor.f(p._1(), p._2(), p._3())))).map(List::join);
    }

    static Validation<NonEmptyList<Exception>, List<Unit>> executeHelper(String path, Map<String, String> classNameMethodNameParameterMap) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(classNameMethodNameParameterMap);
        F2 writeTo = (file, javaFile) -> ((Validation)TryEffect.f(() -> javaFile.writeTo(file))._1()).f().map(x$0 -> NonEmptyList.nel((Object)x$0, (Object[])new Exception[0]));
        return JavaPoetMojo.directoryFor(path).bind(file -> JavaPoetMojo.javaFileStreamListFor((HashMap<String, String>)HashMap.fromMap((Map)classNameMethodNameParameterMap)).bind(list -> Validation.sequence((Semigroup)Semigroup.nonEmptyListSemigroup(), (List)list.map(javaFile -> (Validation)writeTo.f(file, javaFile)))));
    }

    public void execute() {
        JavaPoetMojo.executeHelper(this.path, this.methods).f().forEach(nel -> nel.forEach(exception -> this.getLog().error((Throwable)exception)));
    }
}

