/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query.index;

import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.query.index.Index;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class NodeIndex
implements Index<ASTNode> {
    public final Map<Class<? extends ASTNode>, Set<? extends ASTNode>> index = new HashMap<Class<? extends ASTNode>, Set<? extends ASTNode>>();
    public final Supplier<Set<ASTNode>> bucketConstructor;

    public NodeIndex(Supplier<Set<ASTNode>> bucketConstructor) {
        this.bucketConstructor = bucketConstructor;
    }

    public NodeIndex() {
        this(HashSet::new);
    }

    public static NodeIndex withHashSetBuckets() {
        return new NodeIndex(HashSet::new);
    }

    public static NodeIndex withLinkedHashSetBuckets() {
        return new NodeIndex(LinkedHashSet::new);
    }

    @Override
    public void add(ASTNode node) {
        Set<? extends ASTNode> set = this.index.get(node.getClass());
        if (set == null) {
            set = this.bucketConstructor.get();
            this.index.put(node.getClass(), set);
        }
        set.add(node);
    }

    @Override
    public void remove(ASTNode node) {
        Set<? extends ASTNode> set = this.index.get(node.getClass());
        if (set == null) {
            return;
        }
        set.remove(node);
    }

    public <T extends ASTNode> Set<T> get(Class<T> clazz) {
        Set<? extends ASTNode> result = this.index.get(clazz);
        return result == null ? Collections.emptySet() : result;
    }

    public <T extends ASTNode> Stream<T> getStream(Class<T> clazz) {
        Set<? extends ASTNode> result = this.index.get(clazz);
        return result == null ? Stream.empty() : result.stream();
    }

    public <T extends ASTNode> T getOne(Class<T> clazz) {
        Set<? extends ASTNode> result = this.index.get(clazz);
        return (T)(result == null ? null : result.iterator().next());
    }

    public boolean has(Class<? extends ASTNode> clazz) {
        Set<? extends ASTNode> result = this.index.get(clazz);
        return result != null && !result.isEmpty();
    }

    public <T extends ASTNode> Set<T> get(T node) {
        return this.get((T)((Object)node.getClass()));
    }

    public <T extends ASTNode> T getOne(T node) {
        return (T)this.getOne((T)((Object)node.getClass()));
    }

    public boolean has(ASTNode node) {
        return this.has(node.getClass());
    }

    public boolean hasExact(ASTNode node) {
        Set<ASTNode> set = this.get(node);
        return set != null && set.contains(node);
    }

    public void merge(NodeIndex other) {
        for (Map.Entry<Class<? extends ASTNode>, Set<? extends ASTNode>> entry : other.index.entrySet()) {
            Set<? extends ASTNode> set = this.index.get(entry.getKey());
            if (set == null) {
                set = this.bucketConstructor.get();
                this.index.put(entry.getKey(), set);
            }
            set.addAll((Collection<? extends ASTNode>)entry.getValue());
        }
    }
}

