/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query.index;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.query.index.Index;
import io.github.douira.glsl_transformer.ast.query.index.PermutermTrie;
import io.github.douira.glsl_transformer.ast.query.index.PrefixQueryable;
import io.github.douira.glsl_transformer.ast.query.index.PrefixSuffixTrie;
import io.github.douira.glsl_transformer.ast.query.index.PrefixTrie;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class IdentifierIndex<I extends PatriciaTrie<Set<Identifier>>>
implements Index<Identifier>,
PrefixQueryable<Identifier> {
    public final I index;

    public IdentifierIndex(I index) {
        this.index = index;
    }

    @Override
    public void add(Identifier node) {
        String name = node.getName();
        HashSet<Identifier> set = (HashSet<Identifier>)((PatriciaTrie)this.index).get(name);
        if (set == null) {
            set = new HashSet<Identifier>();
            ((PatriciaTrie)this.index).put(name, set);
        }
        set.add(node);
    }

    @Override
    public void remove(Identifier node) {
        String name = node.getName();
        Set set = (Set)((PatriciaTrie)this.index).get(name);
        if (set == null) {
            return;
        }
        set.remove(node);
        if (set.isEmpty()) {
            ((PatriciaTrie)this.index).remove(name);
        }
    }

    public void merge(IdentifierIndex<?> other) {
        for (Map.Entry entry : ((PatriciaTrie)other.index).entrySet()) {
            HashSet set = (HashSet)((PatriciaTrie)this.index).get(entry.getKey());
            if (set == null) {
                set = new HashSet();
                ((PatriciaTrie)this.index).put((String)entry.getKey(), set);
            }
            set.addAll((Collection)entry.getValue());
        }
    }

    public Set<Identifier> get(String k) {
        Set result = (Set)((PatriciaTrie)this.index).get(k);
        return result == null ? Collections.emptySet() : result;
    }

    public Stream<Identifier> getStream(String k) {
        Set result = (Set)((PatriciaTrie)this.index).get(k);
        return result == null ? Stream.empty() : result.stream();
    }

    public Identifier getOne(String k) {
        return (Identifier)((Set)((PatriciaTrie)this.index).get(k)).iterator().next();
    }

    public boolean has(String k) {
        Set result = (Set)((PatriciaTrie)this.index).get(k);
        return result != null && !result.isEmpty();
    }

    public SortedMap<String, Set<Identifier>> prefixMap(String key) {
        return ((PatriciaTrie)this.index).prefixMap(key);
    }

    @Override
    public Stream<Set<Identifier>> prefixQuery(String key) {
        return ((PatriciaTrie)this.index).prefixMap(key).values().stream();
    }

    @Override
    public Stream<Identifier> prefixQueryFlat(String key) {
        return this.prefixQuery(key).flatMap(Collection::stream);
    }

    public static IdentifierIndex<PrefixTrie<Identifier>> withPrefix() {
        return new IdentifierIndex<PrefixTrie<Identifier>>(new PrefixTrie());
    }

    public static IdentifierIndex<PrefixSuffixTrie<Identifier>> withPrefixSuffix() {
        return new IdentifierIndex<PrefixSuffixTrie<Identifier>>(new PrefixSuffixTrie());
    }

    public static IdentifierIndex<PermutermTrie<Identifier>> withPermuterm() {
        return new IdentifierIndex<PermutermTrie<Identifier>>(new PermutermTrie());
    }
}

