/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.query.index.IdentifierIndex;
import io.github.douira.glsl_transformer.ast.query.index.NodeIndex;
import io.github.douira.glsl_transformer.ast.query.match.HintedMatcher;
import io.github.douira.glsl_transformer.ast.query.match.Matcher;
import io.github.douira.glsl_transformer.ast.transform.ASTTransformer;
import io.github.douira.glsl_transformer.util.Passthrough;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Root {
    public final NodeIndex nodeIndex;
    public final IdentifierIndex<?> identifierIndex;
    private List<? extends ASTNode> nodeList;
    private static Deque<Root> activeBuildRoots = new ArrayDeque<Root>();

    public static Root getActiveBuildRoot() {
        return activeBuildRoots.peekLast();
    }

    protected static final synchronized <R> R withActiveBuildRoot(Root instance, Function<Root, R> rootConsumer) {
        activeBuildRoots.addLast(instance);
        try {
            R r = rootConsumer.apply(instance);
            return r;
        }
        finally {
            activeBuildRoots.removeLast();
        }
    }

    public static synchronized <NodeType extends ASTNode> NodeType indexNodes(Root instance, Supplier<NodeType> builder) {
        return (NodeType)Root.withActiveBuildRoot(instance, root -> {
            ASTNode result = (ASTNode)builder.get();
            root.registerNode(result);
            return result;
        });
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(Supplier<NodeType> builder) {
        return Root.indexNodes(new Root(), builder);
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(ASTNode parentTreeMember, Supplier<NodeType> builder) {
        return Root.indexNodes(parentTreeMember.getRoot(), builder);
    }

    public static synchronized void indexBuildSession(Root instance, Runnable session) {
        Root.withActiveBuildRoot(instance, root -> {
            session.run();
            return null;
        });
    }

    public static void indexBuildSession(Runnable session) {
        Root.indexBuildSession(new Root(), session);
    }

    public static void indexBuildSession(ASTNode treeMember, Runnable session) {
        Root.indexBuildSession(treeMember.getRoot(), session);
    }

    public static synchronized <NodeType extends ASTNode> void indexSeparateTrees(Root instance, Consumer<Passthrough<NodeType>> registererConsumer) {
        Root.withActiveBuildRoot(instance, root -> {
            registererConsumer.accept(Passthrough.of(root::registerNode));
            return null;
        });
    }

    public static <NodeType extends ASTNode> void indexSeparateTrees(Consumer<Passthrough<NodeType>> registerer) {
        Root.indexSeparateTrees(new Root(), registerer);
    }

    public static <NodeType extends ASTNode> void indexSeparateTrees(ASTNode treeMember, Consumer<Passthrough<NodeType>> registerer) {
        Root.indexSeparateTrees(treeMember.getRoot(), registerer);
    }

    public Root(NodeIndex nodeIndex, IdentifierIndex<?> identifierIndex) {
        this.nodeIndex = nodeIndex;
        this.identifierIndex = identifierIndex;
    }

    public Root() {
        this(new NodeIndex(), IdentifierIndex.withPrefix());
    }

    public void registerNode(ASTNode node) {
        this.nodeIndex.add(node);
        ASTNode aSTNode = node;
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            this.identifierIndex.add(identifier);
        }
    }

    public void unregisterNode(ASTNode node) {
        this.nodeIndex.remove(node);
        ASTNode aSTNode = node;
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            this.identifierIndex.remove(identifier);
        }
    }

    public void merge(Root other) {
        this.nodeIndex.merge(other.nodeIndex);
        this.identifierIndex.merge(other.identifierIndex);
    }

    private void ensureEmptyNodeList() {
        if (this.nodeList == null) {
            this.nodeList = new ArrayList<ASTNode>();
        } else {
            this.nodeList.clear();
        }
    }

    public void rename(String oldName, String newName) {
        this.ensureEmptyNodeList();
        Set<Identifier> set = this.identifierIndex.get(oldName);
        if (set == null) {
            return;
        }
        List<? extends ASTNode> identifierList = this.nodeList;
        identifierList.addAll(set);
        for (Identifier identifier : identifierList) {
            identifier.setName(newName);
        }
    }

    public <T extends ASTNode> void process(Stream<? extends T> targets, Consumer<? super T> replacer) {
        this.ensureEmptyNodeList();
        if (targets == null) {
            return;
        }
        List<? extends ASTNode> typedList = this.nodeList;
        targets.forEach(typedList::add);
        for (ASTNode aSTNode : typedList) {
            if (aSTNode == null) continue;
            replacer.accept(aSTNode);
        }
    }

    public void process(String name, Consumer<Identifier> replacer) {
        this.process(this.identifierIndex.getStream(name), replacer);
    }

    public void replaceReferenceExpressions(ASTTransformer<?> t, String name, String expression) {
        this.replaceReferenceExpressions(t, this.identifierIndex.getStream(name), expression);
    }

    public void replaceReferenceExpressions(ASTTransformer<?> t, Stream<Identifier> targets, String expression) {
        this.process(targets, (? super T identifier) -> {
            ASTNode parent = identifier.getParent();
            if (!(parent instanceof ReferenceExpression)) {
                return;
            }
            parent.replaceByAndDelete(t.parseExpression((ASTNode)identifier, expression));
        });
    }

    public void replaceExpressions(ASTTransformer<?> t, Stream<? extends Expression> targets, String expression) {
        this.process(targets, (? super T node) -> node.replaceByAndDelete(t.parseExpression((ASTNode)node, expression)));
    }

    public static void replaceExpressionsConcurrent(ASTTransformer<?> t, List<? extends Expression> targets, String expression) {
        for (Expression expression2 : targets) {
            expression2.replaceByAndDelete(t.parseExpression(expression2, expression));
        }
    }

    public <T extends ASTNode> void processMatches(ASTTransformer<?> t, Stream<? extends ASTNode> matchTargetChildren, Matcher<T> matcher, Consumer<? super T> replacer) {
        Class matchClass = matcher.getPatternClass();
        this.process(matchTargetChildren.map(node -> node.getAncestor(matchClass)).distinct().filter(matcher::matches), replacer);
    }

    public <T extends ASTNode> void processMatches(ASTTransformer<?> t, String matchHint, Matcher<T> matcher, Consumer<? super T> replacer) {
        this.processMatches(t, this.identifierIndex.getStream(matchHint), matcher, replacer);
    }

    public <T extends ASTNode> void processMatches(ASTTransformer<?> t, HintedMatcher<T> hintedMatcher, Consumer<? super T> replacer) {
        this.processMatches(t, hintedMatcher.getHint(), hintedMatcher, replacer);
    }

    public <T extends Expression> void replaceExpressionMatches(ASTTransformer<?> t, Stream<? extends ASTNode> matchTargetChildren, Matcher<T> matcher, String expression) {
        Class matchClass = matcher.getPatternClass();
        this.replaceExpressions(t, matchTargetChildren.map(node -> (Expression)node.getAncestor(matchClass)).distinct().filter(matcher::matches), expression);
    }

    public <T extends Expression> void replaceExpressionMatches(ASTTransformer<?> t, String matchHint, Matcher<T> matcher, String expression) {
        this.replaceExpressionMatches(t, this.identifierIndex.getStream(matchHint), matcher, expression);
    }

    public <T extends Expression> void replaceExpressionMatches(ASTTransformer<?> t, HintedMatcher<T> hintedMatcher, String expression) {
        this.replaceExpressionMatches(t, hintedMatcher.getHint(), hintedMatcher, expression);
    }
}

