/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.print;

import io.github.douira.glsl_transformer.ast.print.SimpleASTPrinter;
import io.github.douira.glsl_transformer.ast.print.token.IndentMarker;
import io.github.douira.glsl_transformer.ast.print.token.PrintToken;

public class IndentingASTPrinter
extends SimpleASTPrinter {
    private final char indent;
    private final int indentMultiplier;
    private int indentLevel = 0;
    private boolean indentationPrinted = false;

    public IndentingASTPrinter(char indent, int indentMultiplier) {
        this.indent = indent;
        this.indentMultiplier = indentMultiplier;
    }

    public IndentingASTPrinter() {
        this('\t', 1);
    }

    @Override
    protected void appendToken(PrintToken token) {
        PrintToken printToken = token;
        if (printToken instanceof IndentMarker) {
            IndentMarker indentMarker = (IndentMarker)printToken;
            this.indentLevel += indentMarker.indentDelta;
        } else {
            boolean isNewline;
            String content = token.getContent();
            boolean bl = isNewline = content != null && content.endsWith("\n");
            if (!this.indentationPrinted && !isNewline) {
                this.indentationPrinted = true;
                if (this.indentLevel > 0) {
                    int repeat = this.indentLevel * this.indentMultiplier;
                    for (int i = 0; i < repeat; ++i) {
                        this.builder.append(this.indent);
                    }
                }
            }
            if (isNewline) {
                this.indentationPrinted = false;
            }
            super.appendToken(token);
        }
    }
}

