/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.node.basic.InnerASTNode;
import io.github.douira.glsl_transformer.ast.node.basic.ListASTNode;
import io.github.douira.glsl_transformer.ast.query.NodeIndex;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class SuperclassNodeIndex
extends NodeIndex {
    public SuperclassNodeIndex(Supplier<Set<ASTNode>> bucketConstructor) {
        super(bucketConstructor);
    }

    public SuperclassNodeIndex() {
    }

    public static SuperclassNodeIndex withHashSetBuckets() {
        return new SuperclassNodeIndex(HashSet::new);
    }

    public static SuperclassNodeIndex withLinkedHashSetBuckets() {
        return new SuperclassNodeIndex(LinkedHashSet::new);
    }

    protected void iterateClasses(ASTNode node, BiConsumer<Class<? extends ASTNode>, ASTNode> consumer) {
        for (Class<?> clazz = node.getClass(); clazz != null && clazz != InnerASTNode.class && clazz != ASTNode.class && clazz != ListASTNode.class; clazz = clazz.getSuperclass()) {
            consumer.accept(clazz, node);
        }
    }

    @Override
    public void add(ASTNode node) {
        this.iterateClasses(node, (clazz, toAdd) -> {
            Set set = (Set)this.index.get(clazz);
            if (set == null) {
                set = (Set)this.bucketConstructor.get();
                this.index.put(clazz, set);
            }
            set.add(toAdd);
        });
    }

    @Override
    public void remove(ASTNode node) {
        this.iterateClasses(node, (clazz, toAdd) -> {
            Set set = (Set)this.index.get(clazz);
            if (set == null) {
                return;
            }
            set.remove(toAdd);
        });
    }
}

