/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.query.IdentifierIndex;
import io.github.douira.glsl_transformer.ast.query.NodeIndex;
import io.github.douira.glsl_transformer.ast.transform.ASTTransformer;
import io.github.douira.glsl_transformer.util.Passthrough;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Root {
    public final NodeIndex nodeIndex;
    public final IdentifierIndex<?> identifierIndex;
    private List<? extends ASTNode> nodeList;
    private static Deque<Root> activeBuildRoots = new ArrayDeque<Root>();

    public static Root getActiveBuildRoot() {
        return activeBuildRoots.peekLast();
    }

    protected static final synchronized <R> R withActiveBuildRoot(Root instance, Function<Root, R> rootConsumer) {
        activeBuildRoots.addLast(instance);
        try {
            R r = rootConsumer.apply(instance);
            return r;
        }
        finally {
            activeBuildRoots.removeLast();
        }
    }

    public static synchronized <NodeType extends ASTNode> NodeType indexNodes(Root instance, Supplier<NodeType> builder) {
        return (NodeType)Root.withActiveBuildRoot(instance, root -> {
            ASTNode result = (ASTNode)builder.get();
            root.registerNode(result);
            return result;
        });
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(Supplier<NodeType> builder) {
        return Root.indexNodes(new Root(), builder);
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(ASTNode parentTreeMember, Supplier<NodeType> builder) {
        return Root.indexNodes(parentTreeMember.getRoot(), builder);
    }

    public static synchronized void indexBuildSession(Root instance, Runnable session) {
        Root.withActiveBuildRoot(instance, root -> {
            session.run();
            return null;
        });
    }

    public static void indexBuildSession(Runnable session) {
        Root.indexBuildSession(new Root(), session);
    }

    public static void indexBuildSession(ASTNode treeMember, Runnable session) {
        Root.indexBuildSession(treeMember.getRoot(), session);
    }

    public static synchronized <NodeType extends ASTNode> void indexSeparateTrees(Root instance, Consumer<Passthrough<NodeType>> registererConsumer) {
        Root.withActiveBuildRoot(instance, root -> {
            registererConsumer.accept(Passthrough.of(root::registerNode));
            return null;
        });
    }

    public static <NodeType extends ASTNode> void indexSeparateTrees(Consumer<Passthrough<NodeType>> registerer) {
        Root.indexSeparateTrees(new Root(), registerer);
    }

    public static <NodeType extends ASTNode> void indexSeparateTrees(ASTNode treeMember, Consumer<Passthrough<NodeType>> registerer) {
        Root.indexSeparateTrees(treeMember.getRoot(), registerer);
    }

    public Root(NodeIndex nodeIndex, IdentifierIndex<?> identifierIndex) {
        this.nodeIndex = nodeIndex;
        this.identifierIndex = identifierIndex;
    }

    public Root() {
        this(new NodeIndex(), IdentifierIndex.withPrefix());
    }

    public void registerNode(ASTNode node) {
        this.nodeIndex.add(node);
        ASTNode aSTNode = node;
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            this.identifierIndex.add(identifier);
        }
    }

    public void unregisterNode(ASTNode node) {
        this.nodeIndex.remove(node);
        ASTNode aSTNode = node;
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            this.identifierIndex.remove(identifier);
        }
    }

    public void merge(Root other) {
        this.nodeIndex.merge(other.nodeIndex);
        this.identifierIndex.merge(other.identifierIndex);
    }

    private void ensureEmptyNodeList() {
        if (this.nodeList == null) {
            this.nodeList = new ArrayList<ASTNode>();
        } else {
            this.nodeList.clear();
        }
    }

    public void renameAll(String oldName, String newName) {
        this.ensureEmptyNodeList();
        Set<Identifier> set = this.identifierIndex.get(oldName);
        if (set == null) {
            return;
        }
        List<? extends ASTNode> identifierList = this.nodeList;
        identifierList.addAll(set);
        for (Identifier identifier : identifierList) {
            identifier.setName(newName);
        }
    }

    public <T extends ASTNode> void processAll(Stream<T> targets, Consumer<T> replacer) {
        this.ensureEmptyNodeList();
        if (targets == null) {
            return;
        }
        List<? extends ASTNode> typedList = this.nodeList;
        targets.forEach(typedList::add);
        for (ASTNode aSTNode : typedList) {
            if (aSTNode == null) continue;
            replacer.accept(aSTNode);
        }
    }

    public void processAll(String name, Consumer<Identifier> replacer) {
        this.processAll(this.identifierIndex.getStream(name), replacer);
    }

    public void replaceAllReferenceExpressions(ASTTransformer<?> transformer, String name, String expressionContent) {
        this.replaceAllReferenceExpressions(transformer, this.identifierIndex.getStream(name), expressionContent);
    }

    public void replaceAllReferenceExpressions(ASTTransformer<?> transformer, Stream<Identifier> targets, String expressionContent) {
        this.processAll(targets, (T identifier) -> {
            ASTNode parent = identifier.getParent();
            if (!(parent instanceof ReferenceExpression)) {
                return;
            }
            parent.replaceByAndDelete(transformer.parseExpression((ASTNode)identifier, expressionContent));
        });
    }

    public void replaceAllExpressions(ASTTransformer<?> transformer, Stream<? extends Expression> targets, String expressionContent) {
        this.processAll(targets, (T expression) -> expression.replaceByAndDelete(transformer.parseExpression((ASTNode)expression, expressionContent)));
    }

    public static void replaceAllExpressionsConcurrent(ASTTransformer<?> transformer, List<? extends Expression> targets, String expressionContent) {
        for (Expression expression : targets) {
            expression.replaceByAndDelete(transformer.parseExpression(expression, expressionContent));
        }
    }
}

