/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.node.type.qualifier;

import io.github.douira.glsl_transformer.ast.data.ChildNodeList;
import io.github.douira.glsl_transformer.ast.data.TokenTyped;
import io.github.douira.glsl_transformer.ast.data.TypeUtil;
import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifierPart;
import io.github.douira.glsl_transformer.ast.traversal.ASTListener;
import io.github.douira.glsl_transformer.ast.traversal.ASTVisitor;
import java.util.List;
import java.util.stream.Stream;
import org.antlr.v4.runtime.Token;

public class StorageQualifier
extends TypeQualifierPart {
    public final List<Identifier> typeNames;
    public StorageType storageType;

    public StorageQualifier(Stream<Identifier> typeNames) {
        this.typeNames = ChildNodeList.collect(typeNames, this);
        this.storageType = StorageType.SUBROUTINE;
    }

    public StorageQualifier(StorageType storageType) {
        this.typeNames = null;
        this.storageType = storageType;
    }

    @Override
    public TypeQualifierPart.QualifierType getQualifierType() {
        return TypeQualifierPart.QualifierType.STORAGE;
    }

    @Override
    public <R> R typeQualifierPartAccept(ASTVisitor<R> visitor) {
        return visitor.visitStorageQualifier(this);
    }

    @Override
    public void enterNode(ASTListener listener) {
        super.enterNode(listener);
        listener.enterStorageQualifier(this);
    }

    @Override
    public void exitNode(ASTListener listener) {
        super.exitNode(listener);
        listener.exitStorageQualifier(this);
    }

    public static enum StorageType implements TokenTyped
    {
        CONST(11),
        IN(4),
        OUT(5),
        INOUT(6),
        CENTROID(17),
        PATCH(19),
        SAMPLE(18),
        UNIFORM(2),
        VARYING(24),
        ATTRIBUTE(20),
        BUFFER(3),
        SHARED(27),
        RESTRICT(23),
        VOLATILE(22),
        COHERENT(21),
        READONLY(25),
        WRITEONLY(26),
        SUBROUTINE(28),
        DEVICECOHERENT(29),
        QUEUEFAMILYCOHERENT(30),
        WORKGROUPCOHERENT(31),
        SUBGROUPCOHERENT(32),
        NONPRIVATE(33);

        public final int tokenType;

        private StorageType(int tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public int getTokenType() {
            return this.tokenType;
        }

        public static StorageType fromToken(Token token) {
            return (StorageType)TypeUtil.enumFromToken((TokenTyped[])StorageType.values(), (Token)token);
        }
    }
}

