/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.node.expression;

import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.TerminalExpression;
import io.github.douira.glsl_transformer.ast.traversal.ASTListener;
import io.github.douira.glsl_transformer.ast.traversal.ASTVisitor;
import io.github.douira.glsl_transformer.util.Type;

public class LiteralExpression
extends TerminalExpression {
    public Type literalType;
    public boolean booleanValue;
    public long integerValue;
    public IntegerFormat integerFormat;
    public double floatingValue;

    public LiteralExpression(Type literalType, boolean booleanValue) {
        this.literalType = literalType;
        this.booleanValue = booleanValue;
    }

    public LiteralExpression(Type literalType, long integerValue) {
        this(literalType, integerValue, IntegerFormat.DECIMAL);
    }

    public LiteralExpression(Type literalType, long integerValue, IntegerFormat integerFormat) {
        this.literalType = literalType;
        this.integerValue = integerValue;
        this.integerFormat = integerFormat;
    }

    public LiteralExpression(Type literalType, double floatingValue) {
        this.literalType = literalType;
        this.floatingValue = floatingValue;
    }

    public Number getNumber() {
        int bitDepth = this.literalType.getBitDepth();
        switch (this.literalType.getNumberType()) {
            case BOOLEAN: {
                return this.booleanValue ? 1 : 0;
            }
            case SIGNED_INTEGER: 
            case UNSIGNED_INTEGER: {
                switch (bitDepth) {
                    case 8: {
                        return (byte)this.integerValue;
                    }
                    case 16: {
                        return (short)this.integerValue;
                    }
                    case 32: {
                        return (int)this.integerValue;
                    }
                    case 64: {
                        return this.integerValue;
                    }
                }
                throw new IllegalArgumentException("Unsupported bit depth: " + bitDepth);
            }
            case FLOATING_POINT: {
                if (bitDepth == 64) {
                    return this.floatingValue;
                }
                return Float.valueOf((float)this.floatingValue);
            }
        }
        throw new IllegalArgumentException("Unsupported literal type: " + this.literalType);
    }

    public boolean isPositive() {
        switch (this.literalType.getNumberType()) {
            case BOOLEAN: {
                return true;
            }
            case SIGNED_INTEGER: 
            case UNSIGNED_INTEGER: {
                return this.integerValue > 0L;
            }
            case FLOATING_POINT: {
                return this.floatingValue > 0.0;
            }
        }
        throw new IllegalArgumentException("Unsupported literal type: " + this.literalType);
    }

    public boolean isNonZero() {
        switch (this.literalType.getNumberType()) {
            case BOOLEAN: {
                return this.booleanValue;
            }
            case SIGNED_INTEGER: 
            case UNSIGNED_INTEGER: {
                return this.integerValue != 0L;
            }
            case FLOATING_POINT: {
                return this.floatingValue != 0.0;
            }
        }
        throw new IllegalArgumentException("Unsupported literal type: " + this.literalType);
    }

    public int getIntegerRadix() {
        return this.integerFormat == IntegerFormat.HEXADECIMAL ? 16 : (this.integerFormat == IntegerFormat.OCTAL ? 8 : 10);
    }

    public boolean isBoolean() {
        return this.literalType.getNumberType() == Type.NumberType.BOOLEAN;
    }

    public boolean isInteger() {
        return this.literalType.getNumberType() == Type.NumberType.SIGNED_INTEGER || this.literalType.getNumberType() == Type.NumberType.UNSIGNED_INTEGER;
    }

    public boolean isFloatingPoint() {
        return this.literalType.getNumberType() == Type.NumberType.FLOATING_POINT;
    }

    @Override
    public Expression.ExpressionType getExpressionType() {
        return Expression.ExpressionType.LITERAL;
    }

    @Override
    public <R> R expressionAccept(ASTVisitor<R> visitor) {
        return visitor.visitLiteralExpression(this);
    }

    @Override
    public void enterNode(ASTListener listener) {
        super.enterNode(listener);
        listener.enterLiteralExpression(this);
    }

    @Override
    public void exitNode(ASTListener listener) {
        super.exitNode(listener);
        listener.exitLiteralExpression(this);
    }

    public static enum IntegerFormat {
        DECIMAL,
        HEXADECIMAL,
        OCTAL;

    }
}

