/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.transform;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.transform.ASTBuilder;
import io.github.douira.glsl_transformer.ast.traversal.ASTVisitor;
import io.github.douira.glsl_transformer.ast.traversal.ASTVoidVisitor;
import io.github.douira.glsl_transformer.basic.EnhancedParser;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class Matcher {
    private final ASTNode pattern;
    private List<Object> patternItems;
    private int patternItemsSize;
    private int matchIndex;
    private boolean matches;
    private ASTVisitor<?> matchVisitor = new ASTVoidVisitor(){

        @Override
        public void visitVoid(ASTNode node) {
            Matcher.this.matches = Matcher.this.matches && Matcher.this.matchIndex < Matcher.this.patternItemsSize && node.getClass() == Matcher.this.patternItems.get(Matcher.this.matchIndex++).getClass();
        }

        @Override
        public void visitVoid(Object data) {
            Matcher.this.matches = Matcher.this.matches && Matcher.this.matchIndex < Matcher.this.patternItemsSize && !(data instanceof ASTNode) && data.equals(Matcher.this.patternItems.get(Matcher.this.matchIndex++));
        }

        @Override
        public Void visit(ASTNode node) {
            if (!Matcher.this.matches) {
                return null;
            }
            return super.visit(node);
        }
    };

    public Matcher(ASTNode pattern) {
        this.pattern = pattern;
    }

    public Matcher(String input, Function<GLSLParser, ? extends ExtendedContext> parseMethod) {
        this(ASTBuilder.build(EnhancedParser.getInternalInstance().parse(input, parseMethod)));
    }

    public boolean matches(ASTNode tree) {
        if (tree == null) {
            return false;
        }
        this.preparePatternItems();
        this.matchIndex = 0;
        this.matches = true;
        this.matchVisitor.startVisit(tree);
        return this.matches;
    }

    public void preparePatternItems() {
        if (this.patternItems == null) {
            this.patternItems = new ArrayList<Object>();
            new ASTVoidVisitor(){

                @Override
                public void visitVoid(ASTNode node) {
                    Matcher.this.patternItems.add(node);
                }

                @Override
                public void visitVoid(Object data) {
                    Matcher.this.patternItems.add(data);
                }
            }.startVisit(this.pattern);
            this.patternItemsSize = this.patternItems.size();
        }
    }
}

