/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.transform;

import io.github.douira.glsl_transformer.GLSLLexer;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.statement.Statement;
import io.github.douira.glsl_transformer.ast.print.ASTPrinter;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.ASTBuilder;
import io.github.douira.glsl_transformer.basic.EnhancedParser;
import io.github.douira.glsl_transformer.basic.ParserInterface;
import io.github.douira.glsl_transformer.job_parameter.JobParameters;
import io.github.douira.glsl_transformer.job_parameter.ParameterizedTransformer;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import io.github.douira.glsl_transformer.util.TriConsumer;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.RecognitionException;

public class ASTTransformer<T extends JobParameters>
implements ParameterizedTransformer<T>,
ParserInterface {
    private final EnhancedParser parser;
    private Consumer<TranslationUnit> transformation;
    private T jobParameters;

    public ASTTransformer() {
        this.parser = new EnhancedParser();
    }

    public ASTTransformer(boolean throwParseErrors) {
        this.parser = new EnhancedParser(throwParseErrors);
    }

    public ASTTransformer(Consumer<TranslationUnit> transformation, boolean throwParseErrors) {
        this(throwParseErrors);
        this.setTransformation(transformation);
    }

    public ASTTransformer(Consumer<TranslationUnit> transformation) {
        this();
        this.setTransformation(transformation);
    }

    public ASTTransformer(BiConsumer<TranslationUnit, Root> transformation) {
        this();
        this.setTransformation(transformation);
    }

    public ASTTransformer(TriConsumer<TranslationUnit, Root, T> transformation) {
        this();
        this.setTransformation(transformation);
    }

    public void setTransformation(Consumer<TranslationUnit> transformation) {
        this.transformation = transformation;
    }

    public void setTransformation(BiConsumer<TranslationUnit, Root> transformation) {
        this.transformation = ASTTransformer.wrapTransformation(this, transformation);
    }

    public void setTransformation(TriConsumer<TranslationUnit, Root, T> transformation) {
        this.transformation = ASTTransformer.wrapTransformation(this, transformation);
    }

    public static <T> Consumer<TranslationUnit> wrapTransformation(ParameterizedTransformer<T> transformer, TriConsumer<TranslationUnit, Root, T> transformation) {
        return translationUnit -> transformation.accept((TranslationUnit)translationUnit, translationUnit.getRoot(), transformer.getJobParameters());
    }

    public static Consumer<TranslationUnit> wrapTransformation(ParameterizedTransformer<?> transformer, BiConsumer<TranslationUnit, Root> transformation) {
        return translationUnit -> transformation.accept((TranslationUnit)translationUnit, translationUnit.getRoot());
    }

    @Override
    public GLSLLexer getLexer() {
        return this.parser.getLexer();
    }

    @Override
    public GLSLParser getParser() {
        return this.parser.getParser();
    }

    @Override
    public EnhancedParser getInternalParser() {
        return this.parser;
    }

    @Override
    public void setParsingStrategy(EnhancedParser.ParsingStrategy parsingStrategy) {
        this.parser.setParsingStrategy(parsingStrategy);
    }

    @Override
    public void setSLLOnly() {
        this.parser.setSLLOnly();
    }

    @Override
    public void setLLOnly() {
        this.parser.setLLOnly();
    }

    public <RuleType extends ExtendedContext> ASTNode parseTranslationUnit(String input, Function<GLSLParser, RuleType> parseMethod) throws RecognitionException {
        return ASTBuilder.build(this.parser.parse(input, parseMethod));
    }

    public <RuleType extends ExtendedContext, ReturnType extends ASTNode> ReturnType parseNode(String input, ASTNode parentTreeMember, Function<GLSLParser, RuleType> parseMethod, BiFunction<ASTBuilder, RuleType, ReturnType> visitMethod) throws RecognitionException {
        return ASTBuilder.buildSubtreeWith(parentTreeMember, this.parser.parse(input, parseMethod), visitMethod);
    }

    public <RuleType extends ExtendedContext, ReturnType extends ASTNode> ReturnType parseNodeWithoutRoot(String input, Function<GLSLParser, RuleType> parseMethod, BiFunction<ASTBuilder, RuleType, ReturnType> visitMethod) throws RecognitionException {
        return ASTBuilder.build(this.parser.parse(input, parseMethod), visitMethod);
    }

    public ASTNode parseNodeWithoutRoot(String input, Function<GLSLParser, ? extends ExtendedContext> parseMethod) throws RecognitionException {
        return ASTBuilder.build(this.parser.parse(input, parseMethod));
    }

    public String transformBare(PrintType printType, String str) throws RecognitionException {
        GLSLParser.TranslationUnitContext parseTree = this.parser.parse((IntStream)CharStreams.fromString((String)str), null, GLSLParser::translationUnit);
        TranslationUnit translationUnit = (TranslationUnit)ASTBuilder.build(parseTree);
        this.transformation.accept(translationUnit);
        return ASTPrinter.print(printType, translationUnit);
    }

    public String transform(PrintType printType, String str, T parameters) throws RecognitionException {
        return this.withJobParameters(parameters, () -> this.transformBare(printType, str));
    }

    public String transform(PrintType printType, String str) throws RecognitionException {
        return this.transform(printType, str, null);
    }

    @Override
    public T getJobParameters() {
        return this.jobParameters;
    }

    @Override
    public void setJobParameters(T parameters) {
        this.jobParameters = parameters;
    }

    @Override
    public String transformBare(String str) throws RecognitionException {
        return this.transformBare(PrintType.INDENTED, str);
    }

    public ExternalDeclaration parseExternalDeclaration(TranslationUnit parent, String input) throws RecognitionException {
        return this.parseNode(input, parent, GLSLParser::externalDeclaration, ASTBuilder::visitExternalDeclaration);
    }

    public Expression parseExpression(ASTNode parent, String input) throws RecognitionException {
        return this.parseNode(input, parent, GLSLParser::expression, ASTBuilder::visitExpression);
    }

    public Statement parseStatement(ASTNode parent, String input) throws RecognitionException {
        return this.parseNode(input, parent, GLSLParser::statement, ASTBuilder::visitStatement);
    }
}

