/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.query.IdentifierIndex;
import io.github.douira.glsl_transformer.ast.query.NodeIndex;
import io.github.douira.glsl_transformer.util.Passthrough;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Root {
    public final NodeIndex nodeIndex;
    public final IdentifierIndex<?> identifierIndex;
    private static Deque<Root> activeBuildRoots = new ArrayDeque<Root>();

    public static Root getActiveBuildRoot() {
        return activeBuildRoots.peekLast();
    }

    protected static synchronized <R> R withActiveBuildRoot(Root instance, Function<Root, R> rootConsumer) {
        activeBuildRoots.addLast(instance);
        try {
            R r = rootConsumer.apply(instance);
            return r;
        }
        finally {
            activeBuildRoots.removeLast();
        }
    }

    public static synchronized <NodeType extends ASTNode> NodeType indexNodes(Root instance, Supplier<NodeType> builder) {
        return (NodeType)Root.withActiveBuildRoot(instance, root -> {
            ASTNode result = (ASTNode)builder.get();
            root.registerChild(result);
            return result;
        });
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(Supplier<NodeType> builder) {
        return Root.indexNodes(new Root(), builder);
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(ASTNode parentTreeMember, Supplier<NodeType> builder) {
        return Root.indexNodes(parentTreeMember.getRoot(), builder);
    }

    public static synchronized void indexBuildSession(Root instance, Runnable session) {
        Root.withActiveBuildRoot(instance, root -> {
            session.run();
            return null;
        });
    }

    public static void indexBuildSession(Runnable session) {
        Root.indexBuildSession(new Root(), session);
    }

    public static void indexBuildSession(ASTNode parentTreeMember, Runnable session) {
        Root.indexBuildSession(parentTreeMember.getRoot(), session);
    }

    protected static synchronized <NodeType extends ASTNode> void indexSeparateTrees(Root instance, Consumer<Passthrough<NodeType>> registererConsumer) {
        Root.withActiveBuildRoot(instance, root -> {
            registererConsumer.accept(Passthrough.of(root::registerChild));
            return null;
        });
    }

    public static <NodeType extends ASTNode> void indexSeparateTrees(Consumer<Passthrough<NodeType>> registerer) {
        Root.indexSeparateTrees(new Root(), registerer);
    }

    public static <NodeType extends ASTNode> void indexSeparateTrees(ASTNode parentTreeMember, Consumer<Passthrough<NodeType>> registerer) {
        Root.indexSeparateTrees(parentTreeMember.getRoot(), registerer);
    }

    public Root(NodeIndex nodeIndex, IdentifierIndex<?> identifierIndex) {
        this.nodeIndex = nodeIndex;
        this.identifierIndex = identifierIndex;
    }

    public Root() {
        this(new NodeIndex(), IdentifierIndex.withPrefix());
    }

    public void registerChild(ASTNode child) {
        this.nodeIndex.add(child);
        ASTNode aSTNode = child;
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            this.identifierIndex.add(identifier);
        }
    }

    public void unregisterChild(ASTNode child) {
        this.nodeIndex.remove(child);
        ASTNode aSTNode = child;
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            this.identifierIndex.remove(identifier);
        }
    }

    public void merge(Root other) {
        this.nodeIndex.merge(other.nodeIndex);
        this.identifierIndex.merge(other.identifierIndex);
    }
}

