/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.node.statement.selection;

import io.github.douira.glsl_transformer.ast.data.ChildNodeList;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.statement.ManyStatement;
import io.github.douira.glsl_transformer.ast.node.statement.Statement;
import io.github.douira.glsl_transformer.ast.traversal.ASTListener;
import io.github.douira.glsl_transformer.ast.traversal.ASTVisitor;
import java.util.List;
import java.util.stream.Stream;

public class SelectionStatement
extends ManyStatement {
    public final List<Expression> conditions;

    public SelectionStatement(Stream<Expression> conditions, Stream<Statement> statements) {
        super(statements);
        this.conditions = ChildNodeList.collect(conditions, this);
    }

    public SelectionStatement(Expression condition, Statement statement) {
        this(Stream.of(condition), Stream.of(statement));
    }

    public SelectionStatement(Expression condition, Statement ifTrue, Statement ifFalse) {
        this(Stream.of(condition, null), Stream.of(ifTrue, ifFalse));
    }

    public SelectionStatement(Expression firstCondition, Statement firstStatement, Expression secondCondition, Statement secondStatement, Statement elseStatement) {
        this(Stream.of(firstCondition, secondCondition, null), Stream.of(firstStatement, secondStatement, elseStatement));
    }

    public List<Expression> getConditions() {
        return this.conditions;
    }

    @Override
    public Statement.StatementType getStatementType() {
        return Statement.StatementType.SELECTION;
    }

    @Override
    public <R> R statementAccept(ASTVisitor<R> visitor) {
        return visitor.visitSelectionStatement(this);
    }

    @Override
    public void enterNode(ASTListener listener) {
        super.enterNode(listener);
        listener.enterSelectionStatement(this);
    }

    @Override
    public void exitNode(ASTListener listener) {
        super.exitNode(listener);
        listener.exitSelectionStatement(this);
    }
}

