/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.node.basic;

import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.traversal.ASTVisitor;
import io.github.douira.glsl_transformer.ast.traversal.ASTVoidVisitor;
import io.github.douira.glsl_transformer.util.CompatUtil;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class ASTNode {
    private ASTNode parent;
    private Consumer<ASTNode> selfReplacer;
    private Root root = Root.getActiveBuildRoot();
    private boolean registered = false;

    public abstract <R> R accept(ASTVisitor<R> var1);

    public ASTNode getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Consumer<ASTNode> getParentSetter() {
        return this.selfReplacer;
    }

    public ASTNode getNthParent(int n) {
        ASTNode node = this;
        for (int i = 0; i < n; ++i) {
            if (node == null) {
                return null;
            }
            node = node.getParent();
        }
        return node;
    }

    public boolean hasAncestor(int limit, int skip, Predicate<ASTNode> predicate) {
        ASTNode node = this;
        for (int i = 0; i <= limit; ++i) {
            if (node == null) {
                return false;
            }
            if (predicate.test(node) && i >= skip) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public boolean hasAncestor(int limit, Predicate<ASTNode> predicate) {
        return this.hasAncestor(limit, 0, predicate);
    }

    public boolean hasAncestor(Predicate<ASTNode> predicate) {
        return this.hasAncestor(Integer.MAX_VALUE, predicate);
    }

    public boolean hasAncestor(Class<? extends ASTNode> clazz) {
        return this.hasAncestor(clazz::isInstance);
    }

    public boolean hasAncestor(ASTNode node) {
        return this.hasAncestor(node::equals);
    }

    public ASTNode getAncestor(int limit, int skip, Predicate<ASTNode> predicate) {
        ASTNode node = this;
        for (int i = 0; i <= limit; ++i) {
            if (node == null) {
                return null;
            }
            if (predicate.test(node) && i >= skip) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    public ASTNode getAncestor(int limit, Predicate<ASTNode> predicate) {
        return this.getAncestor(limit, 0, predicate);
    }

    public ASTNode getAncestor(Predicate<ASTNode> predicate) {
        return this.getAncestor(Integer.MAX_VALUE, predicate);
    }

    public <T extends ASTNode> T getAncestor(Class<T> clazz) {
        return (T)this.getAncestor(clazz::isInstance);
    }

    public Stream<ASTNode> getAncestors() {
        return CompatUtil.iterateStream(this, ASTNode::hasParent, ASTNode::getParent);
    }

    public Root getRoot() {
        return this.root;
    }

    private void setRoot(Root root) {
        if (this.root == root) {
            return;
        }
        if (this.registered) {
            this.unregister();
        }
        this.root = root;
        this.register();
    }

    private void unregister() {
        this.root.unregisterChild(this);
        this.registered = false;
    }

    private void register() {
        this.root.registerChild(this);
        this.registered = true;
    }

    public boolean setParent(ASTNode parent, Consumer<? extends ASTNode> setter) {
        Objects.requireNonNull(parent);
        if (this.parent == parent) {
            return false;
        }
        if (this.root == parent.root) {
            this.parent = parent;
            this.selfReplacer = setter;
            if (!this.registered) {
                this.register();
            }
            return true;
        }
        this.parent = parent;
        this.selfReplacer = setter;
        new ChangeRootVisitor(parent.root).visit(this);
        return true;
    }

    public boolean replaceBy(ASTNode replacement) {
        if (this.selfReplacer != null) {
            this.selfReplacer.accept(replacement);
            return true;
        }
        return false;
    }

    public boolean replaceByAndDelete(ASTNode replacement) {
        if (this.replaceBy(replacement)) {
            this.unregisterSubtree();
            return true;
        }
        return false;
    }

    public boolean detach() {
        return this.replaceBy(null);
    }

    public boolean detachAndDelete() {
        return this.replaceByAndDelete(null);
    }

    public void detachParent() {
        this.parent = null;
        this.selfReplacer = null;
    }

    public boolean unregisterSubtree() {
        this.detachParent();
        new UnregisterVisitor().visit(this);
        return true;
    }

    public static boolean swap(ASTNode a, ASTNode b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        ASTNode bParent = b.getParent();
        ASTNode aParent = a.getParent();
        Objects.requireNonNull(aParent);
        Objects.requireNonNull(bParent);
        if (aParent == b || bParent == a) {
            return false;
        }
        Consumer<ASTNode> bReplacer = b.selfReplacer;
        a.replaceBy(b);
        bReplacer.accept(a);
        return true;
    }

    public <NodeType extends ASTNode> NodeType setup(NodeType node, Consumer<? extends NodeType> setter) {
        if (node != null) {
            node.setParent(this, setter);
        }
        return node;
    }

    public <NodeType extends ASTNode> void updateParents(NodeType currentNode, NodeType newNode, Consumer<? extends NodeType> setter) {
        if (currentNode == newNode) {
            return;
        }
        if (currentNode != null) {
            currentNode.detachParent();
        }
        if (newNode != null) {
            newNode.setParent(this, setter);
        }
    }

    class ChangeRootVisitor
    extends ASTVoidVisitor {
        private Root root;

        public ChangeRootVisitor(Root root) {
            this.root = root;
        }

        @Override
        public void visitVoid(ASTNode node) {
            node.setRoot(this.root);
        }
    }

    class UnregisterVisitor
    extends ASTVoidVisitor {
        UnregisterVisitor() {
        }

        @Override
        public void visitVoid(ASTNode node) {
            node.unregister();
        }
    }
}

