package io.github.douira.glsl_transformer.cst.node;

import java.util.function.Function;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.basic.EnhancedParser;
import io.github.douira.glsl_transformer.tree.ExtendedContext;

/**
 * The parsable a CST node defines how CST nodes that can be converted back into
 * parse tree nodes are handled. The construction of CST nodes can vary a lot
 * and is not defined here.
 */
public abstract class ParsableTerminalCSTNode extends TerminalCSTNode {
  /**
   * This method is overwritten by the implementing class to specify with which
   * parser method the generated string should be parsed.
   * 
   * @return A method reference from
   *         {@link io.github.douira.glsl_transformer.GLSLParser}
   */
  protected abstract Function<GLSLParser, ExtendedContext> getOutputParseMethod();

  /**
   * Parses this CST node's generated code into a parse tree node without
   * attaching a parent node.
   * 
   * @see #getParsed(ExtendedContext)
   * 
   * @return The CST node's code parsed into a node
   */
  public ExtendedContext getParsed() {
    return getParsed(null);
  }

  /**
   * Parses the code generated by this CST node with the parser method supplied by
   * {@link #getOutputParseMethod()} into a parse tree node..
   * 
   * @param parent The parent node to attach to the parsed node
   * @return The CST node's code parsed into a node
   */
  public ExtendedContext getParsed(ExtendedContext parent) {
    return EnhancedParser.getInternalInstance().parse(
        getPrinted(), parent, getOutputParseMethod());
  }
}
