/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.query.DuplicatorTrie;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class PrefixSuffixTrie<E>
extends DuplicatorTrie<E> {
    private static final int removeThreshold = 200;
    private Map<String, String> reverses = new HashMap<String, String>();

    private String getReverse(String key) {
        if (this.reverses.containsKey(key)) {
            return this.reverses.get(key);
        }
        String reverse = new StringBuilder(key).reverse().toString();
        this.reverses.put(key, reverse);
        this.reverses.put(reverse, key);
        return reverse;
    }

    @Override
    protected void iterateKeyVariations(String key, Consumer<String> consumer) {
        consumer.accept(key);
        consumer.accept(this.marker + this.getReverse(key));
    }

    @Override
    public E remove(Object k) {
        Object previous = super.remove(k);
        if (this.reverses.size() >= 200) {
            this.reverses.remove(this.reverses.remove(k));
        }
        return previous;
    }

    public Stream<E> prefixQuery(String prefix) {
        return this.distinctPrefixQuery(this.sanitizeKey(prefix));
    }

    public Stream<E> suffixQuery(String suffix) {
        return this.distinctPrefixQuery(this.marker + this.getReverse(this.sanitizeKey(suffix)));
    }
}

