/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.query.DuplicatorTrie;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class PermutermTrie<E>
extends DuplicatorTrie<E> {
    public PermutermTrie() {
    }

    public PermutermTrie(Map<? extends String, ? extends E> m) {
        super(m);
    }

    public PermutermTrie(char marker) {
        super(marker);
    }

    public PermutermTrie(Map<? extends String, ? extends E> m, char marker) {
        super(m, marker);
    }

    @Override
    protected void iterateKeyVariations(String key, Consumer<String> consumer) {
        int length = key.length();
        for (int i = 0; i <= length; ++i) {
            consumer.accept(key.substring(i) + this.marker + key.substring(0, i));
        }
    }

    @Override
    protected String prepareKey(Object k) {
        return super.prepareKey(k) + this.marker;
    }

    public Stream<E> prefixQuery(String prefix) {
        return this.distinctPrefixQuery(this.marker + this.sanitizeKey(prefix));
    }

    public Stream<E> suffixQuery(String suffix) {
        return this.distinctPrefixQuery(this.sanitizeKey(suffix) + this.marker);
    }

    public Stream<E> infixQuery(String infix) {
        return this.distinctPrefixQuery(this.sanitizeKey(infix));
    }

    public Stream<E> suffixPrefixQuery(String prefix, String suffix) {
        return this.distinctPrefixQuery(this.sanitizeKey(suffix) + this.marker + this.sanitizeKey(prefix));
    }
}

