/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.query.Index;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NodeIndex
implements Index<ASTNode> {
    public final Map<Class<? extends ASTNode>, Set<? extends ASTNode>> index = new HashMap<Class<? extends ASTNode>, Set<? extends ASTNode>>();

    @Override
    public void add(ASTNode node) {
        Set<? extends ASTNode> set = this.index.get(node.getClass());
        if (set == null) {
            set = new HashSet<ASTNode>();
            this.index.put(node.getClass(), set);
        }
        set.add(node);
    }

    @Override
    public void remove(ASTNode node) {
        Set<? extends ASTNode> set = this.index.get(node.getClass());
        if (set == null) {
            return;
        }
        set.remove(node);
    }

    public <T extends ASTNode> Set<T> get(Class<T> clazz) {
        Set<? extends ASTNode> result = this.index.get(clazz);
        return result == null ? Collections.emptySet() : result;
    }

    public <T extends ASTNode> T getOne(Class<T> clazz) {
        Set<? extends ASTNode> result = this.index.get(clazz);
        return (T)(result == null ? null : result.iterator().next());
    }

    public boolean has(Class<? extends ASTNode> clazz) {
        Set<? extends ASTNode> result = this.index.get(clazz);
        return result != null && !result.isEmpty();
    }

    public <T extends ASTNode> Set<T> get(T node) {
        return this.get((T)((Object)node.getClass()));
    }

    public <T extends ASTNode> T getOne(T node) {
        return (T)this.getOne((T)((Object)node.getClass()));
    }

    public boolean has(ASTNode node) {
        return this.has(node.getClass());
    }

    public void merge(NodeIndex other) {
        for (Map.Entry<Class<? extends ASTNode>, Set<? extends ASTNode>> entry : other.index.entrySet()) {
            Set<? extends ASTNode> set = this.index.get(entry.getKey());
            if (set == null) {
                set = new HashSet<ASTNode>();
                this.index.put(entry.getKey(), set);
            }
            set.addAll((Collection<? extends ASTNode>)entry.getValue());
        }
    }
}

