/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.query.Index;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class IdentifierIndex
implements Index<Identifier> {
    public final PatriciaTrie<Set<Identifier>> index;

    public IdentifierIndex(PatriciaTrie<Set<Identifier>> index) {
        this.index = index;
    }

    public IdentifierIndex() {
        this(new PatriciaTrie<Set<Identifier>>());
    }

    @Override
    public void add(Identifier node) {
        HashSet<Identifier> set = (HashSet<Identifier>)this.index.get(node.name);
        if (set == null) {
            set = new HashSet<Identifier>();
            this.index.put(node.name, set);
        }
        set.add(node);
    }

    @Override
    public void remove(Identifier node) {
        Set set = (Set)this.index.get(node.name);
        if (set == null) {
            return;
        }
        set.remove(node);
        if (set.isEmpty()) {
            this.index.remove(node.name);
        }
    }

    public void merge(IdentifierIndex other) {
        for (Map.Entry entry : other.index.entrySet()) {
            HashSet set = (HashSet)this.index.get(entry.getKey());
            if (set == null) {
                set = new HashSet();
                this.index.put((String)entry.getKey(), set);
            }
            set.addAll((Collection)entry.getValue());
        }
    }

    public Set<Identifier> get(String k) {
        Set result = (Set)this.index.get(k);
        return result == null ? Collections.emptySet() : result;
    }

    public Identifier getOne(String k) {
        return (Identifier)((Set)this.index.get(k)).iterator().next();
    }

    public boolean has(String k) {
        Set result = (Set)this.index.get(k);
        return result != null && !result.isEmpty();
    }

    public SortedMap<String, Set<Identifier>> prefixMap(String key) {
        return this.index.prefixMap(key);
    }
}

