/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.transform;

import io.github.douira.glsl_transformer.GLSLLexer;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.print.ASTPrinter;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.transform.ASTBuilder;
import io.github.douira.glsl_transformer.basic.EnhancedParser;
import io.github.douira.glsl_transformer.basic.ParserInterface;
import io.github.douira.glsl_transformer.job_parameter.JobParameters;
import io.github.douira.glsl_transformer.job_parameter.ParameterizedTransformer;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.RecognitionException;

public class ASTTransformer<T extends JobParameters>
implements ParameterizedTransformer<T>,
ParserInterface {
    private final EnhancedParser parser;
    private Consumer<TranslationUnit> transformation;
    private T jobParameters;

    public ASTTransformer() {
        this.parser = new EnhancedParser();
    }

    public ASTTransformer(boolean throwParseErrors) {
        this.parser = new EnhancedParser(throwParseErrors);
    }

    public ASTTransformer(Consumer<TranslationUnit> transformation) {
        this();
        this.transformation = transformation;
    }

    public ASTTransformer(Consumer<TranslationUnit> transformation, boolean throwParseErrors) {
        this(throwParseErrors);
        this.transformation = transformation;
    }

    public void setTransformation(Consumer<TranslationUnit> transformation) {
        this.transformation = transformation;
    }

    @Override
    public GLSLLexer getLexer() {
        return this.parser.getLexer();
    }

    @Override
    public GLSLParser getParser() {
        return this.parser.getParser();
    }

    @Override
    public EnhancedParser getInternalParser() {
        return this.parser;
    }

    @Override
    public void setParsingStrategy(EnhancedParser.ParsingStrategy parsingStrategy) {
        this.parser.setParsingStrategy(parsingStrategy);
    }

    @Override
    public void setSLLOnly() {
        this.parser.setSLLOnly();
    }

    @Override
    public void setLLOnly() {
        this.parser.setLLOnly();
    }

    public <RuleType extends ExtendedContext> ASTNode parseNode(String input, Function<GLSLParser, RuleType> parseMethod) throws RecognitionException {
        RuleType parseTree = this.parser.parse(input, null, parseMethod);
        return ASTBuilder.build(parseTree);
    }

    public <RuleType extends ExtendedContext> ASTNode parseNode(String input, ASTNode parentTreeMember, Function<GLSLParser, RuleType> parseMethod) throws RecognitionException {
        RuleType parseTree = this.parser.parse(input, null, parseMethod);
        return ASTBuilder.buildSubtreeFor(parentTreeMember, parseTree);
    }

    public <RuleType extends ExtendedContext, ReturnType extends ASTNode> ReturnType parseNode(String input, ASTNode parentTreeMember, Function<GLSLParser, RuleType> parseMethod, BiFunction<ASTBuilder, RuleType, ReturnType> visitMethod) throws RecognitionException {
        RuleType parseTree = this.parser.parse(input, null, parseMethod);
        return ASTBuilder.buildSubtreeWith(parentTreeMember, parseTree, visitMethod);
    }

    public String transformBare(PrintType printType, String str) throws RecognitionException {
        GLSLParser.TranslationUnitContext parseTree = this.parser.parse((IntStream)CharStreams.fromString((String)str), null, GLSLParser::translationUnit);
        TranslationUnit translationUnit = (TranslationUnit)ASTBuilder.build(parseTree);
        this.transformation.accept(translationUnit);
        return ASTPrinter.printIndented(translationUnit);
    }

    public String transform(PrintType printType, String str, T parameters) throws RecognitionException {
        return this.withJobParameters(parameters, () -> this.transformBare(printType, str));
    }

    public String transform(PrintType printType, String str) throws RecognitionException {
        return this.transform(printType, str, null);
    }

    @Override
    public T getJobParameters() {
        return this.jobParameters;
    }

    @Override
    public void setJobParameters(T parameters) {
        this.jobParameters = parameters;
    }

    @Override
    public String transformBare(String str) throws RecognitionException {
        return this.transformBare(PrintType.INDENTED, str);
    }
}

