/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.query.IdentifierIndex;
import io.github.douira.glsl_transformer.ast.query.NodeIndex;
import io.github.douira.glsl_transformer.util.Passthrough;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Root {
    public final NodeIndex nodeIndex;
    public final IdentifierIndex identifierIndex;
    private static Root activeBuildRoot;

    public static Root getActiveBuildRoot() {
        return activeBuildRoot;
    }

    protected static synchronized <R> R withActiveBuildRoot(Root instance, Function<Root, R> rootConsumer) {
        if (activeBuildRoot != null) {
            throw new IllegalStateException("There is already a build in progress");
        }
        activeBuildRoot = instance;
        try {
            R r = rootConsumer.apply(instance);
            return r;
        }
        finally {
            activeBuildRoot = null;
        }
    }

    public static synchronized <NodeType extends ASTNode> NodeType indexNodes(Root instance, Supplier<NodeType> builder) {
        return (NodeType)Root.withActiveBuildRoot(instance, root -> {
            ASTNode result = (ASTNode)builder.get();
            root.registerChild(result);
            return result;
        });
    }

    protected static synchronized <NodeType extends ASTNode> void indexNodes(Root instance, Consumer<Passthrough<NodeType>> registerer) {
        Root.withActiveBuildRoot(instance, root -> {
            registerer.accept(Passthrough.of(root::registerChild));
            return null;
        });
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(Supplier<NodeType> builder) {
        return Root.indexNodes(new Root(), builder);
    }

    public static <NodeType extends ASTNode> NodeType indexNodes(ASTNode parentTreeMember, Supplier<NodeType> builder) {
        return Root.indexNodes(parentTreeMember.getRoot(), builder);
    }

    public static <NodeType extends ASTNode> void indexNodes(Consumer<Passthrough<NodeType>> registerer) {
        Root.indexNodes(new Root(), registerer);
    }

    public static <NodeType extends ASTNode> void indexNodes(ASTNode parentTreeMember, Consumer<Passthrough<NodeType>> registerer) {
        Root.indexNodes(parentTreeMember.getRoot(), registerer);
    }

    public Root(NodeIndex nodeIndex, IdentifierIndex identifierIndex) {
        this.nodeIndex = nodeIndex;
        this.identifierIndex = identifierIndex;
    }

    public Root() {
        this(new NodeIndex(), new IdentifierIndex());
    }

    public void registerChild(ASTNode child) {
        this.nodeIndex.add(child);
        if (child instanceof Identifier) {
            this.identifierIndex.add((Identifier)child);
        }
    }

    public void unregisterChild(ASTNode child) {
        this.nodeIndex.remove(child);
        if (child instanceof Identifier) {
            this.identifierIndex.remove((Identifier)child);
        }
    }

    public void merge(Root other) {
        this.nodeIndex.merge(other.nodeIndex);
        this.identifierIndex.merge(other.identifierIndex);
    }
}

