/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import java.util.Map;
import java.util.SortedMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class PermutermTrie<E>
extends PatriciaTrie<E> {
    public static final char DEFAULT_MARKER = '$';
    private final char marker;

    public PermutermTrie() {
        this.marker = (char)36;
    }

    public PermutermTrie(Map<? extends String, ? extends E> m) {
        super(m);
        this.marker = (char)36;
    }

    public PermutermTrie(char marker) {
        this.marker = marker;
    }

    public PermutermTrie(Map<? extends String, ? extends E> m, char marker) {
        super(m);
        this.marker = marker;
    }

    private void iteratePermutations(String key, Consumer<String> consumer) {
        int length = key.length();
        for (int i = 0; i <= length; ++i) {
            consumer.accept(key.substring(i) + this.marker + key.substring(0, i));
        }
    }

    private String prepareKey(Object k) {
        return this.sanitizeKey(k.toString()) + this.marker;
    }

    private String sanitizeKey(String key) {
        if (key.indexOf(this.marker) >= 0) {
            throw new IllegalArgumentException("Key cannot contain marker");
        }
        return key;
    }

    @Override
    public boolean containsKey(Object k) {
        return super.containsKey(this.prepareKey(k));
    }

    @Override
    public E get(Object k) {
        return (E)super.get(this.prepareKey(k));
    }

    @Override
    public SortedMap<String, E> headMap(String toKey) {
        return super.headMap(this.prepareKey(toKey));
    }

    @Override
    public String nextKey(String key) {
        return (String)super.nextKey(this.prepareKey(key));
    }

    @Override
    public SortedMap<String, E> prefixMap(String key) {
        return super.prefixMap(this.prepareKey(key));
    }

    @Override
    public String previousKey(String key) {
        return (String)super.previousKey(this.prepareKey(key));
    }

    @Override
    public E put(String key, E value) {
        E previous = this.get(key);
        this.iteratePermutations(key, k -> super.put(k, value));
        return previous;
    }

    @Override
    public E remove(Object k) {
        E previous = this.get(k);
        this.iteratePermutations((String)k, x$0 -> super.remove(x$0));
        return previous;
    }

    @Override
    public Map.Entry<String, E> select(String key) {
        return super.select(this.prepareKey(key));
    }

    @Override
    public String selectKey(String key) {
        return (String)super.selectKey(this.prepareKey(key));
    }

    @Override
    public SortedMap<String, E> subMap(String fromKey, String toKey) {
        return super.subMap(this.prepareKey(fromKey), this.prepareKey(toKey));
    }

    @Override
    public SortedMap<String, E> tailMap(String fromKey) {
        return super.tailMap(this.prepareKey(fromKey));
    }

    private Stream<E> distinctPrefixQuery(String prefix) {
        return ((Stream)super.prefixMap(prefix).values().stream().unordered()).distinct();
    }

    public Stream<E> prefixQuery(String prefix) {
        return this.distinctPrefixQuery(this.marker + this.sanitizeKey(prefix));
    }

    public Stream<E> suffixQuery(String suffix) {
        return this.distinctPrefixQuery(this.sanitizeKey(suffix) + this.marker);
    }

    public Stream<E> infixQuery(String infix) {
        return this.distinctPrefixQuery(this.sanitizeKey(infix));
    }

    public Stream<E> suffixPrefixQuery(String prefix, String suffix) {
        return this.distinctPrefixQuery(this.sanitizeKey(suffix) + this.marker + this.sanitizeKey(prefix));
    }

    public static final class Holder<V> {
        public V value;

        public Holder(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }
    }
}

