/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.node.basic;

import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.traversal.ASTVisitor;
import io.github.douira.glsl_transformer.ast.traversal.ASTVoidVisitor;
import java.util.function.Consumer;

public abstract class ASTNode {
    private ASTNode parent;
    private Consumer<ASTNode> selfReplacer;
    private Root root = Root.getActiveBuildRoot();

    public abstract <R> R accept(ASTVisitor<R> var1);

    public ASTNode getParent() {
        return this.parent;
    }

    public Consumer<ASTNode> getParentSetter() {
        return this.selfReplacer;
    }

    public boolean replaceInParent(ASTNode replacement) {
        if (this.selfReplacer != null) {
            this.selfReplacer.accept(replacement);
            return true;
        }
        return false;
    }

    public boolean removeFromParent() {
        return this.replaceInParent(null);
    }

    public ASTNode getNthParent(int n) {
        ASTNode node = this;
        for (int i = 0; i < n; ++i) {
            if (node == null) {
                return null;
            }
            node = node.getParent();
        }
        return node;
    }

    public ASTNode getFirstOfType(int limit, Class<? extends ASTNode> type) {
        if (this.getClass() == type) {
            return this;
        }
        return this.getFirstOfType(limit, type);
    }

    public ASTNode getFirstParentOfType(int limit, Class<? extends ASTNode> type) {
        ASTNode node = this;
        for (int i = 0; i < limit; ++i) {
            if (node == null) {
                return null;
            }
            if ((node = node.getParent()).getClass() != type) continue;
            return node;
        }
        return null;
    }

    public Root getRoot() {
        return this.root;
    }

    private void adoptNewRoot(Root root) {
        this.root = root;
        root.registerChild(this);
    }

    private void unregister() {
        this.root.unregisterChild(this);
    }

    public boolean setParent(ASTNode parent, Consumer<? extends ASTNode> setter) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be set to null");
        }
        if (this.parent == parent) {
            return false;
        }
        if (this.root == parent.root) {
            this.parent = parent;
            this.selfReplacer = setter;
            return true;
        }
        parent.root.merge(this.root);
        this.parent = parent;
        this.selfReplacer = setter;
        new ChangeRootVisitor(parent.root).visit(this);
        return true;
    }

    public void detachFromParent() {
        if (this.parent == null) {
            return;
        }
        new UnregisterVisitor().visit(this);
        this.parent = null;
    }

    public <NodeType extends ASTNode> NodeType setup(NodeType node, Consumer<? extends NodeType> setter) {
        if (node != null) {
            node.setParent(this, setter);
            this.root.registerChild(node);
        }
        return node;
    }

    public <NodeType extends ASTNode> void updateParents(NodeType currentNode, NodeType newNode, Consumer<? extends NodeType> setter) {
        if (currentNode == newNode) {
            return;
        }
        if (currentNode != null) {
            currentNode.detachFromParent();
        }
        if (newNode != null) {
            newNode.setParent(this, setter);
        }
    }

    class ChangeRootVisitor
    extends ASTVoidVisitor {
        private Root root;

        public ChangeRootVisitor(Root root) {
            this.root = root;
        }

        @Override
        public void visitVoid(ASTNode node) {
            node.adoptNewRoot(this.root);
        }
    }

    class UnregisterVisitor
    extends ASTVoidVisitor {
        UnregisterVisitor() {
        }

        @Override
        public void visitVoid(ASTNode node) {
            node.unregister();
        }
    }
}

