/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.data;

import io.github.douira.glsl_transformer.ast.data.ProxyArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public abstract class RemovalProxyArrayList<T>
extends ProxyArrayList<T> {
    public RemovalProxyArrayList() {
    }

    public RemovalProxyArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public RemovalProxyArrayList(Collection<? extends T> c) {
        super(c);
    }

    protected abstract void notifyRemoval(T var1);

    private void notifyRemovalInternal(T removed) {
        if (removed != null) {
            this.notifyRemoval(removed);
        }
    }

    private void notifyRemovalInternal(Collection<? extends T> collection) {
        for (T element : collection) {
            this.notifyRemovalInternal(element);
        }
    }

    @Override
    public T set(int index, T element) {
        T prev = super.set(index, element);
        if (prev != element) {
            this.notifyRemovalInternal(prev);
        }
        return prev;
    }

    @Override
    public T remove(int index) {
        Object removed = super.remove(index);
        this.notifyRemovalInternal(removed);
        return (T)removed;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        if (result) {
            this.notifyRemovalInternal(o);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.notifyRemovalInternal(this);
        boolean result = super.removeAll(c);
        this.notifyAdditionInternal(this);
        return result;
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.notifyRemovalInternal(this);
        super.replaceAll(operator);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.notifyRemovalInternal(this);
        boolean result = super.retainAll(c);
        this.notifyAdditionInternal(this);
        return result;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        this.notifyRemovalInternal(this);
        boolean result = super.removeIf(filter);
        this.notifyAdditionInternal(this);
        return result;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            this.notifyRemovalInternal(this.get(i));
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public void clear() {
        this.notifyRemovalInternal(this);
        super.clear();
    }
}

