/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.UnaryOperator;

public abstract class ProxyArrayList<T>
extends ArrayList<T> {
    public ProxyArrayList() {
    }

    public ProxyArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public ProxyArrayList(Collection<? extends T> c) {
        this(c, true);
    }

    public ProxyArrayList(Collection<? extends T> c, boolean doNotification) {
        super(c);
        if (doNotification) {
            this.notifyAdditionInternal(c);
        }
    }

    protected abstract void notifyAddition(T var1);

    void notifyAdditionInternal(T added) {
        if (added != null) {
            this.notifyAddition(added);
        }
    }

    void notifyAdditionInternal(Collection<? extends T> collection) {
        for (T element : collection) {
            this.notifyAdditionInternal(element);
        }
    }

    @Override
    public boolean add(T e) {
        boolean result = super.add(e);
        this.notifyAdditionInternal(e);
        return result;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.notifyAdditionInternal(element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = super.addAll(c);
        if (result) {
            this.notifyAdditionInternal(c);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result = super.addAll(index, c);
        if (result) {
            this.notifyAdditionInternal(c);
        }
        return result;
    }

    @Override
    public T set(int index, T element) {
        T prev = super.set(index, element);
        if (prev != element) {
            this.notifyAdditionInternal(element);
        }
        return prev;
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        super.replaceAll(operator);
        this.notifyAdditionInternal(this);
    }
}

