/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.basic;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.basic.EnhancedParser;
import io.github.douira.glsl_transformer.cst.token_filter.TokenFilter;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import io.github.douira.glsl_transformer.util.LRUCache;
import java.util.function.Function;

public class CachingParser
extends EnhancedParser {
    private static final int defaultCacheSize = 400;
    private final LRUCache<CacheKey, ExtendedContext> parseCache;

    public CachingParser(boolean throwParseErrors, int cacheSize) {
        super(throwParseErrors);
        this.parseCache = new LRUCache(cacheSize);
    }

    public CachingParser(int cacheSize) {
        this.parseCache = new LRUCache(cacheSize);
    }

    public CachingParser(boolean throwParseErrors) {
        this(throwParseErrors, 400);
    }

    public CachingParser() {
        this(400);
    }

    @Override
    public GLSLParser.TranslationUnitContext parse(String str) {
        return this.parse(str, GLSLParser.TranslationUnitContext.class, GLSLParser::translationUnit);
    }

    public <RuleType extends ExtendedContext> RuleType parse(String str, Class<RuleType> ruleType, Function<GLSLParser, RuleType> parseMethod) {
        return this.parse(str, null, ruleType, parseMethod);
    }

    public <RuleType extends ExtendedContext> RuleType parse(String str, ExtendedContext parent, Class<RuleType> ruleType, Function<GLSLParser, RuleType> parseMethod) {
        return (RuleType)this.parseCache.cachedGet(new CacheKey(str, ruleType), () -> this.parse(str, parent, parseMethod));
    }

    @Override
    public void setParseTokenFilter(TokenFilter<?> parseTokenFilter) {
        super.setParseTokenFilter(parseTokenFilter);
        this.parseCache.clear();
    }

    private static class CacheKey {
        final String input;
        final Class<? extends ExtendedContext> ruleType;

        public CacheKey(String input, Class<? extends ExtendedContext> ruleType) {
            this.input = input;
            this.ruleType = ruleType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
            result = 31 * result + (this.ruleType == null ? 0 : this.ruleType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.input == null ? other.input != null : !this.input.equals(other.input)) {
                return false;
            }
            return !(this.ruleType == null ? other.ruleType != null : !this.ruleType.equals(other.ruleType));
        }
    }
}

