/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.ParsableASTNode;
import io.github.douira.glsl_transformer.generic.ExtendedContext;
import io.github.douira.glsl_transformer.transform.TransformationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Tensor
extends ParsableASTNode {
    private static final int MAX_SPACE_DIMENSIONS = 4;
    private static final TypeRegistry TYPE_REGISTRY = new TypeRegistry();
    private Type type;

    public Tensor(Type type) {
        this.type = type;
    }

    public Tensor(int tokenType) {
        this(TYPE_REGISTRY.getByTokenType(tokenType));
    }

    public Tensor(GLSLParser.BuiltinTypeSpecifierParseableContext ctx) {
        this(Tensor.getTypeSpecifierType(ctx));
    }

    public Tensor(String str) {
        this(TransformationManager.INTERNAL.parse(str, GLSLParser::builtinTypeSpecifierParseable));
    }

    private static int getTypeSpecifierType(GLSLParser.BuiltinTypeSpecifierParseableContext ctx) {
        List children = ctx.children;
        if (children.size() != 1) {
            throw new IllegalArgumentException("Invalid type specifier context given. It must have exactly one child.");
        }
        ParseTree child = (ParseTree)children.get(0);
        ParseTree parseTree = child;
        if (!(parseTree instanceof TerminalNode)) {
            throw new IllegalArgumentException("Type specifier context child has the wrong structure. It should be a terminal node.");
        }
        TerminalNode terminalNode = (TerminalNode)parseTree;
        Token token = terminalNode.getSymbol();
        return token.getType();
    }

    public String getCompactName() {
        return this.type.compactName();
    }

    public String getExplicitName() {
        return this.type.explicitName();
    }

    @Override
    protected String getPrinted() {
        return this.type.compactName();
    }

    @Override
    protected Function<GLSLParser, ExtendedContext> getOutputParseMethod() {
        return GLSLParser::builtinTypeSpecifierParseable;
    }

    static {
        TYPE_REGISTRY.addTypeBool(60, "bool", 1, new int[0]);
        TYPE_REGISTRY.addTypeBool(61, "bvec2", 1, 2);
        TYPE_REGISTRY.addTypeBool(62, "bvec3", 1, 3);
        TYPE_REGISTRY.addTypeBool(63, "bvec4", 1, 4);
        TYPE_REGISTRY.addTypeSignedInteger(64, "int8_t", 8, new int[0]);
        TYPE_REGISTRY.addTypeSignedInteger(65, "i8vec2", 8, 2);
        TYPE_REGISTRY.addTypeSignedInteger(66, "i8vec3", 8, 3);
        TYPE_REGISTRY.addTypeSignedInteger(67, "i8vec4", 8, 4);
        TYPE_REGISTRY.addTypeInteger(68, "uint8_t", 8, new int[0]);
        TYPE_REGISTRY.addTypeInteger(69, "ui8vec2", 8, 2);
        TYPE_REGISTRY.addTypeInteger(70, "ui8vec3", 8, 3);
        TYPE_REGISTRY.addTypeInteger(71, "ui8vec4", 8, 4);
        TYPE_REGISTRY.addTypeSignedInteger(72, "int16_t", 16, new int[0]);
        TYPE_REGISTRY.addTypeSignedInteger(73, "i16vec2", 16, 2);
        TYPE_REGISTRY.addTypeSignedInteger(74, "i16vec3", 16, 3);
        TYPE_REGISTRY.addTypeSignedInteger(75, "i16vec4", 16, 4);
        TYPE_REGISTRY.addTypeInteger(76, "uint16_t", 16, new int[0]);
        TYPE_REGISTRY.addTypeInteger(77, "ui16vec2", 16, 2);
        TYPE_REGISTRY.addTypeInteger(78, "ui16vec3", 16, 3);
        TYPE_REGISTRY.addTypeInteger(79, "ui16vec4", 16, 4);
        TYPE_REGISTRY.addTypeSignedInteger(80, "int", "int32_t", 32, new int[0]);
        TYPE_REGISTRY.addTypeSignedInteger(81, "ivec2", "i32vec2", 32, 2);
        TYPE_REGISTRY.addTypeSignedInteger(82, "ivec3", "i32vec3", 32, 3);
        TYPE_REGISTRY.addTypeSignedInteger(83, "ivec4", "i32vec4", 32, 4);
        TYPE_REGISTRY.addTypeInteger(84, "uint", "uint32_t", 32, new int[0]);
        TYPE_REGISTRY.addTypeInteger(85, "uvec2", "u32vec2", 32, 2);
        TYPE_REGISTRY.addTypeInteger(86, "uvec3", "u32vec3", 32, 3);
        TYPE_REGISTRY.addTypeInteger(87, "uvec4", "u32vec4", 32, 4);
        TYPE_REGISTRY.addTypeSignedInteger(88, "int64_t", 64, new int[0]);
        TYPE_REGISTRY.addTypeSignedInteger(89, "i64vec2", 64, 2);
        TYPE_REGISTRY.addTypeSignedInteger(90, "i64vec3", 64, 3);
        TYPE_REGISTRY.addTypeSignedInteger(91, "i64vec4", 64, 4);
        TYPE_REGISTRY.addTypeInteger(92, "uint64_t", 64, new int[0]);
        TYPE_REGISTRY.addTypeInteger(93, "ui64vec2", 64, 2);
        TYPE_REGISTRY.addTypeInteger(94, "ui64vec3", 64, 3);
        TYPE_REGISTRY.addTypeInteger(95, "ui64vec4", 64, 4);
        TYPE_REGISTRY.addTypeFloating(96, "float16_t", 16, new int[0]);
        TYPE_REGISTRY.addTypeFloating(97, "f16vec2", 16, 2);
        TYPE_REGISTRY.addTypeFloating(98, "f16vec3", 16, 3);
        TYPE_REGISTRY.addTypeFloating(99, "f16vec4", 16, 4);
        TYPE_REGISTRY.addTypeFloating(100, "f16mat2", "f16mat2x2", 16, 2, 2);
        TYPE_REGISTRY.addTypeFloating(101, "f16mat2x3", 16, 2, 3);
        TYPE_REGISTRY.addTypeFloating(102, "f16mat2x4", 16, 2, 4);
        TYPE_REGISTRY.addTypeFloating(103, "f16mat3x2", 16, 3, 2);
        TYPE_REGISTRY.addTypeFloating(104, "f16mat3", "f16mat3x3", 16, 3, 3);
        TYPE_REGISTRY.addTypeFloating(105, "f16mat3x4", 16, 3, 4);
        TYPE_REGISTRY.addTypeFloating(106, "f16mat4x2", 16, 4, 2);
        TYPE_REGISTRY.addTypeFloating(107, "f16mat4x3", 16, 4, 3);
        TYPE_REGISTRY.addTypeFloating(108, "f16mat4", "f16mat4x4", 16, 4, 4);
        TYPE_REGISTRY.addTypeFloating(109, "float", "float32_t", 32, new int[0]);
        TYPE_REGISTRY.addTypeFloating(110, "vec2", "f32vec2", 32, 2);
        TYPE_REGISTRY.addTypeFloating(111, "vec3", "f32vec3", 32, 3);
        TYPE_REGISTRY.addTypeFloating(112, "vec4", "f32vec4", 32, 4);
        TYPE_REGISTRY.addTypeFloating(113, "mat2", "f32mat2x2", 32, 2, 2);
        TYPE_REGISTRY.addTypeFloating(114, "mat2x3", "f32mat2x3", 32, 2, 3);
        TYPE_REGISTRY.addTypeFloating(115, "mat2x4", "f32mat2x4", 32, 2, 4);
        TYPE_REGISTRY.addTypeFloating(116, "mat3x2", "f32mat3x2", 32, 3, 2);
        TYPE_REGISTRY.addTypeFloating(117, "mat3", "f32mat3x3", 32, 3, 3);
        TYPE_REGISTRY.addTypeFloating(118, "mat3x4", "f32mat3x4", 32, 3, 4);
        TYPE_REGISTRY.addTypeFloating(119, "mat4x2", "f32mat4x2", 32, 4, 2);
        TYPE_REGISTRY.addTypeFloating(120, "mat4x3", "f32mat4x3", 32, 4, 3);
        TYPE_REGISTRY.addTypeFloating(121, "mat4", "f32mat4x4", 32, 4, 4);
        TYPE_REGISTRY.addTypeFloating(122, "double", "float64_t", 64, new int[0]);
        TYPE_REGISTRY.addTypeFloating(123, "dvec2", "f64vec2", 64, 2);
        TYPE_REGISTRY.addTypeFloating(124, "dvec3", "f64vec3", 64, 3);
        TYPE_REGISTRY.addTypeFloating(125, "dvec4", "f64vec4", 64, 4);
        TYPE_REGISTRY.addTypeFloating(126, "dmat2", "f64mat2x2", 64, 2, 2);
        TYPE_REGISTRY.addTypeFloating(127, "dmat2x3", "f64mat2x3", 64, 2, 3);
        TYPE_REGISTRY.addTypeFloating(128, "dmat2x4", "f64mat2x4", 64, 2, 4);
        TYPE_REGISTRY.addTypeFloating(129, "dmat3x2", "f64mat3x2", 64, 3, 2);
        TYPE_REGISTRY.addTypeFloating(130, "dmat3", "f64mat3x3", 64, 3, 3);
        TYPE_REGISTRY.addTypeFloating(131, "dmat3x4", "f64mat3x4", 64, 3, 4);
        TYPE_REGISTRY.addTypeFloating(132, "dmat4x2", "f64mat4x2", 64, 4, 2);
        TYPE_REGISTRY.addTypeFloating(133, "dmat4x3", "f64mat4x3", 64, 4, 3);
        TYPE_REGISTRY.addTypeFloating(134, "dmat4", "f64mat4x4", 64, 4, 4);
        TYPE_REGISTRY.collect();
    }

    public static final class Type {
        private final int tokenType;
        private final NumberType numberType;
        private final int[] shape;
        private final int spaceDimensions;
        private final int highestDimension;
        private final String compactName;
        private final String explicitName;

        public Type(int tokenType, NumberType numberType, int[] shape, int spaceDimensions, int highestDimension, String compactName, String explicitName) {
            this.tokenType = tokenType;
            this.numberType = numberType;
            this.shape = shape;
            this.spaceDimensions = spaceDimensions;
            this.highestDimension = highestDimension;
            this.compactName = compactName;
            this.explicitName = explicitName;
        }

        public String toString() {
            return "Type[" + "tokenType=" + this.tokenType + "," + "numberType=" + (Object)((Object)this.numberType) + "," + "shape=" + this.shape + "," + "spaceDimensions=" + this.spaceDimensions + "," + "highestDimension=" + this.highestDimension + "," + "compactName=" + this.compactName + "," + "explicitName=" + this.explicitName + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.tokenType;
            result = 31 * result + (this.numberType != null ? this.numberType.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.shape);
            result = 31 * result + this.spaceDimensions;
            result = 31 * result + this.highestDimension;
            result = 31 * result + (this.compactName != null ? this.compactName.hashCode() : 0);
            result = 31 * result + (this.explicitName != null ? this.explicitName.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((Type)arg0).tokenType != this.tokenType) {
                return false;
            }
            if (!Objects.equals((Object)((Type)arg0).numberType, (Object)this.numberType)) {
                return false;
            }
            if (!Objects.equals(((Type)arg0).shape, this.shape)) {
                return false;
            }
            if (((Type)arg0).spaceDimensions != this.spaceDimensions) {
                return false;
            }
            if (((Type)arg0).highestDimension != this.highestDimension) {
                return false;
            }
            if (!Objects.equals(((Type)arg0).compactName, this.compactName)) {
                return false;
            }
            return Objects.equals(((Type)arg0).explicitName, this.explicitName);
            {
            }
        }

        public int tokenType() {
            return this.tokenType;
        }

        public NumberType numberType() {
            return this.numberType;
        }

        public int[] shape() {
            return this.shape;
        }

        public int spaceDimensions() {
            return this.spaceDimensions;
        }

        public int highestDimension() {
            return this.highestDimension;
        }

        public String compactName() {
            return this.compactName;
        }

        public String explicitName() {
            return this.explicitName;
        }
    }

    private static class TypeRegistry {
        int maxIndex = Integer.MIN_VALUE;
        int minIndex = Integer.MAX_VALUE;
        List<Type> entries = new ArrayList<Type>();
        Type[] types;

        private TypeRegistry() {
        }

        void addType(int tokenType, NumberType numberType, String compactName, String explicitName, int bitDepth, int ... rawShape) {
            int[] shape = new int[4];
            shape[0] = bitDepth;
            int spaceDimensions = 0;
            int highestDimension = 1;
            for (int i = 1; i < 4; ++i) {
                if (i < rawShape.length && rawShape[i] != 1) {
                    shape[i] = rawShape[i];
                    ++spaceDimensions;
                    highestDimension = i + 1;
                    continue;
                }
                shape[i] = 1;
            }
            this.entries.add(new Type(tokenType, numberType, shape, spaceDimensions, highestDimension, compactName, explicitName));
            this.maxIndex = Math.max(this.maxIndex, tokenType);
            this.minIndex = Math.min(this.minIndex, tokenType);
        }

        void addType(int tokenType, NumberType numberType, String name, int bitDepth, int ... rawShape) {
            this.addType(tokenType, numberType, name, name, bitDepth, rawShape);
        }

        void addTypeBool(int tokenType, String compactName, String explicitName, int bitDepth, int ... shape) {
            this.addType(tokenType, NumberType.BOOL, compactName, explicitName, bitDepth, shape);
        }

        void addTypeInteger(int tokenType, String compactName, String explicitName, int bitDepth, int ... shape) {
            this.addType(tokenType, NumberType.INTEGER, compactName, explicitName, bitDepth, shape);
        }

        void addTypeSignedInteger(int tokenType, String compactName, String explicitName, int bitDepth, int ... shape) {
            this.addType(tokenType, NumberType.SIGNED_INTEGER, compactName, explicitName, bitDepth, shape);
        }

        void addTypeFloating(int tokenType, String compactName, String explicitName, int bitDepth, int ... shape) {
            this.addType(tokenType, NumberType.FLOATING, compactName, explicitName, bitDepth, shape);
        }

        void addTypeBool(int tokenType, String name, int bitDepth, int ... shape) {
            this.addType(tokenType, NumberType.BOOL, name, bitDepth, shape);
        }

        void addTypeInteger(int tokenType, String name, int bitDepth, int ... shape) {
            this.addType(tokenType, NumberType.INTEGER, name, bitDepth, shape);
        }

        void addTypeSignedInteger(int tokenType, String name, int bitDepth, int ... shape) {
            this.addType(tokenType, NumberType.SIGNED_INTEGER, name, bitDepth, shape);
        }

        void addTypeFloating(int tokenType, String name, int bitDepth, int ... shape) {
            this.addType(tokenType, NumberType.FLOATING, name, bitDepth, shape);
        }

        void collect() {
            this.types = new Type[this.maxIndex - this.minIndex + 1];
            for (Type entry : this.entries) {
                int index = entry.tokenType - this.minIndex;
                if (this.types[index] != null) {
                    throw new Error("A type was registered multiple times for the same token. Fix the Tensor class' initialization!");
                }
                this.types[index] = entry;
            }
        }

        Type getByTokenType(int tokenType) {
            return this.types[tokenType - this.minIndex];
        }
    }

    public static enum NumberType {
        BOOL(1, 4),
        INTEGER(64, 4),
        SIGNED_INTEGER(64, 4),
        FLOATING(64, 4, 4);

        private int[] maxShape;

        private NumberType(int ... maxShape) {
            this.maxShape = maxShape;
        }
    }
}

