/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.iris;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.generic.ExtendedContext;
import io.github.douira.glsl_transformer.transform.Transformation;
import io.github.douira.glsl_transformer.transform.WalkPhase;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.pattern.ParseTreeMatch;
import org.antlr.v4.runtime.tree.pattern.ParseTreePattern;

public class DeclarationReplacement
extends Transformation {
    private Map<String, Declaration> declarations;

    @Override
    protected void resetState() {
        this.declarations = new HashMap<String, Declaration>();
    }

    public DeclarationReplacement() {
        this.addPhase(new WalkPhase(){
            ParseTreePattern declarationPattern;

            @Override
            protected void init() {
                this.declarationPattern = this.compilePattern("layout (location = 0) <type:storageQualifier> vec4 <name:IDENTIFIER>;", 2);
            }

            @Override
            public void enterExternalDeclaration(GLSLParser.ExternalDeclarationContext ctx) {
                ParseTreeMatch match = this.declarationPattern.match((ParseTree)ctx);
                if (match.succeeded()) {
                    String type = match.get("type").getText();
                    String name = match.get("name").getText();
                    if (name == "iris_Position") {
                        throw new Transformation.SemanticException(DeclarationReplacement.this, String.format("Disallowed GLSL declaration with the name \"{0}\"!", name), ctx);
                    }
                    if (type.equals("in") || type.equals("attribute")) {
                        DeclarationReplacement.this.declarations.put(name, new Declaration(type, name));
                        this.removeNode((ExtendedContext)match.getTree());
                    }
                }
            }

            @Override
            public void enterFunctionHeader(GLSLParser.FunctionHeaderContext ctx) {
                if (ctx.IDENTIFIER().getText().equals("iris_getModelSpaceVertexPosition")) {
                    throw new Transformation.SemanticException(DeclarationReplacement.this, String.format("Disallowed GLSL declaration with the name \"{0}\"!", "iris_getModelSpaceVertexPosition"), ctx);
                }
            }

            @Override
            protected boolean isActiveAfterWalk() {
                return !DeclarationReplacement.this.declarations.isEmpty();
            }

            @Override
            protected void afterWalk(GLSLParser.TranslationUnitContext ctx) {
                ctx.children.add(this.createLocalRoot("void iris_getModelSpaceVertexPosition() { }", ctx, GLSLParser::externalDeclaration));
                ctx.children.add(this.createLocalRoot("layout (location = 0) attribute vec4 iris_Position;", ctx, GLSLParser::externalDeclaration));
            }
        });
        this.addPhase(new WalkPhase(){

            @Override
            protected boolean isActive() {
                return !DeclarationReplacement.this.declarations.isEmpty();
            }

            @Override
            public void enterVariableIdentifier(GLSLParser.VariableIdentifierContext ctx) {
                TerminalNode identifier = ctx.IDENTIFIER();
                Declaration matchingDeclaration = DeclarationReplacement.this.declarations.get(identifier.getText());
                if (matchingDeclaration != null) {
                    this.replaceNode(ctx, "iris_getModelSpaceVertexPosition()", GLSLParser::expression);
                }
            }
        });
    }

    private record Declaration(String type, String name) {
    }
}

