/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.GLSLLexer;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.GLSLParserBaseListener;
import io.github.douira.glsl_transformer.generic.EmptyTerminalNode;
import io.github.douira.glsl_transformer.generic.ExtendedContext;
import io.github.douira.glsl_transformer.transform.PhaseCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.pattern.ParseTreeMatch;
import org.antlr.v4.runtime.tree.pattern.ParseTreePattern;
import org.antlr.v4.runtime.tree.xpath.XPath;

public abstract class TransformationPhase
extends GLSLParserBaseListener {
    private PhaseCollector collector;

    void setParent(PhaseCollector parent) {
        this.collector = parent;
    }

    protected Parser getParser() {
        return this.collector.getParser();
    }

    protected GLSLParser.TranslationUnitContext getRootNode() {
        return this.collector.getRootNode();
    }

    protected static List<ParseTree> getSiblings(ExtendedContext node) {
        ExtendedContext parent = node.getParent();
        return parent == null ? null : parent.children;
    }

    protected void replaceNode(ExtendedContext node, String newContents, Function<GLSLParser, ExtendedContext> parseMethod) {
        int removedIndex = this.removeNode(node);
        TransformationPhase.getSiblings(node).add(removedIndex, (ParseTree)this.createLocalRoot(newContents, node.getParent(), parseMethod));
    }

    protected int removeNode(ExtendedContext removeNode) {
        List<ParseTree> children = TransformationPhase.getSiblings(removeNode);
        int index = children.indexOf((Object)removeNode);
        children.set(index, (ParseTree)new EmptyTerminalNode((ParseTree)removeNode));
        removeNode.omitTokens();
        return index;
    }

    protected XPath compilePath(String xpath) {
        return new XPath(this.getParser(), xpath);
    }

    protected ParseTreePattern compilePattern(String pattern, int rootRule) {
        return this.getParser().compileParseTreePattern(pattern, rootRule, (Lexer)this.collector.getLexer());
    }

    public List<ParseTreeMatch> findAndMatch(ParseTree tree, XPath xpath, ParseTreePattern pattern) {
        Collection subtrees = xpath.evaluate(tree);
        ArrayList<ParseTreeMatch> matches = new ArrayList<ParseTreeMatch>();
        for (ParseTree sub : subtrees) {
            ParseTreeMatch match = pattern.match(sub);
            if (!match.succeeded()) continue;
            matches.add(match);
        }
        return matches;
    }

    protected boolean isActive() {
        return true;
    }

    protected void init() {
    }

    public <RuleType extends ExtendedContext> RuleType createLocalRoot(String str, ExtendedContext parent, Function<GLSLParser, RuleType> parseMethod) {
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)new GLSLLexer((CharStream)CharStreams.fromString((String)str)));
        ExtendedContext node = (ExtendedContext)((Object)parseMethod.apply(new GLSLParser((TokenStream)commonTokenStream)));
        node.setParent(parent);
        node.makeLocalRoot((BufferedTokenStream)commonTokenStream);
        return (RuleType)((Object)node);
    }

    private int getInjectionIndex(InjectionPoint location) {
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        int injectIndex = -1;
        if (location == InjectionPoint.BEFORE_VERSION) {
            injectIndex = rootNode.getChildIndexLike(GLSLParser.VersionStatementContext.class);
        } else if (location == InjectionPoint.BEFORE_EOF) {
            injectIndex = rootNode.getChildCount();
        } else {
            GLSLParser.ExternalDeclarationContext externalDeclaration;
            ParseTree child;
            ParseTree parseTree;
            Set<Class<? extends ParseTree>> beforeTypes = location.EDBeforeTypes;
            if (beforeTypes == null) {
                throw new Error("A non-special injection point is missing its EDBeforeTypes!");
            }
            while (!((parseTree = rootNode.getChild(++injectIndex)) instanceof GLSLParser.ExternalDeclarationContext && (child = (externalDeclaration = (GLSLParser.ExternalDeclarationContext)parseTree).getChild(0)) instanceof ExtendedContext && beforeTypes.contains(child.getClass()) || injectIndex >= rootNode.getChildCount())) {
            }
        }
        return injectIndex;
    }

    public void injectNode(ParseTree newNode, InjectionPoint location) {
        this.getRootNode().addChild(this.getInjectionIndex(location), newNode);
    }

    public void injectNodes(Deque<ParseTree> newNodes, InjectionPoint location) {
        int injectIndex = this.getInjectionIndex(location);
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        newNodes.descendingIterator().forEachRemaining(newNode -> rootNode.addChild(injectIndex, (ParseTree)newNode));
    }

    public void injectExternalDeclaration(String str, InjectionPoint location) {
        this.injectNode((ParseTree)this.createLocalRoot(str, this.getRootNode(), GLSLParser::externalDeclaration), location);
    }

    public static enum InjectionPoint {
        BEFORE_VERSION,
        BEFORE_EXTENSIONS,
        BEFORE_DIRECTIVES,
        BEFORE_DECLARATIONS,
        BEFORE_FUNCTIONS,
        BEFORE_EOF;

        public Set<Class<? extends ParseTree>> EDBeforeTypes;

        static {
            InjectionPoint.BEFORE_FUNCTIONS.EDBeforeTypes = Set.of(GLSLParser.FunctionDefinitionContext.class);
            InjectionPoint.BEFORE_DECLARATIONS.EDBeforeTypes = new HashSet<Class<? extends ParseTree>>(InjectionPoint.BEFORE_FUNCTIONS.EDBeforeTypes);
            InjectionPoint.BEFORE_DECLARATIONS.EDBeforeTypes.add(GLSLParser.LayoutDefaultsContext.class);
            InjectionPoint.BEFORE_DECLARATIONS.EDBeforeTypes.add(GLSLParser.DeclarationContext.class);
            InjectionPoint.BEFORE_DIRECTIVES.EDBeforeTypes = new HashSet<Class<? extends ParseTree>>(InjectionPoint.BEFORE_DECLARATIONS.EDBeforeTypes);
            InjectionPoint.BEFORE_DIRECTIVES.EDBeforeTypes.add(GLSLParser.PragmaStatementContext.class);
            InjectionPoint.BEFORE_EXTENSIONS.EDBeforeTypes = new HashSet<Class<? extends ParseTree>>(InjectionPoint.BEFORE_DIRECTIVES.EDBeforeTypes);
            InjectionPoint.BEFORE_EXTENSIONS.EDBeforeTypes.add(GLSLParser.ExtensionStatementContext.class);
        }
    }
}

