/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.generic.ExtendedContext;
import io.github.douira.glsl_transformer.transform.PhaseCollector;
import io.github.douira.glsl_transformer.transform.TransformationPhase;
import java.util.LinkedList;
import java.util.List;

public class Transformation {
    private List<PhaseEntry> phaseRegistry = new LinkedList<PhaseEntry>();
    private int phaseCounter = 0;

    public Transformation(TransformationPhase phase) {
        this.addPhase(phase);
    }

    public Transformation() {
    }

    public void addPhase(TransformationPhase phase) {
        this.addPhase(this.phaseCounter++, phase);
    }

    public void addPhase(int order, TransformationPhase phase) {
        this.addPhase(order, this.getDefaultGroup(), phase);
    }

    public void addPhase(int order, int group, TransformationPhase phase) {
        this.addPhase(new PhaseEntry(phase, order, group));
    }

    public void addPhase(PhaseEntry entry) {
        this.phaseRegistry.add(entry);
    }

    protected int getDefaultGroup() {
        return 0;
    }

    protected void resetState() {
    }

    void addPhasesTo(PhaseCollector collector) {
        for (PhaseEntry entry : this.phaseRegistry) {
            collector.addPhaseAt(entry);
        }
    }

    public record PhaseEntry(TransformationPhase phase, int order, int group) {
    }

    public class SemanticException
    extends RuntimeException {
        public ExtendedContext node;

        public SemanticException() {
        }

        public SemanticException(String message) {
            super(message);
        }

        public SemanticException(String message, ExtendedContext node) {
            this(message);
            this.node = node;
        }
    }
}

