/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.transform.JobParameters;
import io.github.douira.glsl_transformer.transform.LifecycleUser;
import io.github.douira.glsl_transformer.transform.LifecycleUserImpl;
import io.github.douira.glsl_transformer.transform.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class Transformation<T extends JobParameters>
extends LifecycleUserImpl<T> {
    private final Map<LifecycleUser<T>, Node<T>> contentNodes = new HashMap<LifecycleUser<T>, Node<T>>();
    private final Set<Transformation<T>> transformations = new HashSet<Transformation<T>>();
    private Node<T> rootNode;
    private Node<T> endNode;
    private Node<T> lastDependency;
    private Node<T> lastDependent;
    private boolean usesConditionalGraph = false;
    private Object updateTag;

    public Transformation(LifecycleUser<T> content) {
        this.resetGraph();
        this.addRootDependency(content);
    }

    public Transformation() {
        this.resetGraph();
    }

    protected void triggerJobInternal() {
    }

    protected void setupGraph() {
    }

    private void doGraphSetup(Object updateTag) {
        if (this.updateTag == updateTag) {
            return;
        }
        this.updateTag = updateTag;
        if (this.contentNodes.isEmpty()) {
            this.usesConditionalGraph = true;
        }
        if (this.usesConditionalGraph) {
            this.resetGraph();
            this.setupGraph();
        }
        for (Transformation transformation : this.transformations) {
            transformation.setPlanner(this.getPlanner());
            super.doGraphSetup(updateTag);
        }
    }

    void doGraphSetup() {
        this.doGraphSetup(new Object());
    }

    private void resetGraph() {
        this.rootNode = new Node();
        this.endNode = new Node();
        this.contentNodes.clear();
        this.transformations.clear();
        this.lastDependency = this.rootNode;
        this.lastDependent = this.endNode;
        this.updateInternalLinks();
    }

    Node<T> getRootDepNode() {
        return this.rootNode;
    }

    Node<T> getEndDepNode() {
        return this.endNode;
    }

    Collection<Node<T>> getContentNodes() {
        return this.contentNodes.values();
    }

    private void addContentNode(LifecycleUser<T> content, Node<T> node) {
        this.contentNodes.put(content, node);
        if (content instanceof Transformation) {
            this.transformations.add((Transformation)content);
        }
    }

    private Node<T> getNode(LifecycleUser<T> content) {
        return Optional.ofNullable(this.contentNodes.get(content)).orElseGet(() -> {
            Node newNode = new Node(content);
            this.addContentNode(content, newNode);
            return newNode;
        });
    }

    private void updateInternalLinks() {
        this.rootNode.updateEndLink(this.endNode);
    }

    private void addDependency(Node<T> dependentNode, Node<T> dependencyNode) {
        if (dependencyNode == this.rootNode) {
            throw new AssertionError((Object)"The root node may not be made a dependency. Use prependDependency for replacing the root node.");
        }
        if (dependentNode == this.endNode) {
            throw new AssertionError((Object)"The end node may not be made a dependent. Use appendDependent for replacing the end node.");
        }
        dependentNode.addDependency(dependencyNode);
        this.lastDependent = dependentNode;
        this.lastDependency = dependencyNode;
        dependentNode.updateBothLinks(this.rootNode, this.endNode);
        dependencyNode.updateBothLinks(this.rootNode, this.endNode);
        this.updateInternalLinks();
    }

    private void addDependent(Node<T> dependencyNode, Node<T> dependentNode) {
        this.addDependency(dependentNode, dependencyNode);
    }

    public void addDependency(LifecycleUser<T> dependent, LifecycleUser<T> dependency) {
        this.addDependency(this.getNode(dependent), this.getNode(dependency));
    }

    public void addDependent(LifecycleUser<T> dependency, LifecycleUser<T> dependent) {
        this.addDependent(this.getNode(dependency), this.getNode(dependent));
    }

    public <L extends LifecycleUser<T>> L chainDependency(L dependency) {
        this.addDependency(this.lastDependency, this.getNode(dependency));
        return dependency;
    }

    public <L extends LifecycleUser<T>> L chainDependent(L dependent) {
        this.addDependent(this.lastDependent, this.getNode(dependent));
        return dependent;
    }

    public <L extends LifecycleUser<T>> L addRootDependency(L dependency) {
        this.addDependency(this.rootNode, this.getNode(dependency));
        return dependency;
    }

    public <L extends LifecycleUser<T>> L addEndDependent(L dependent) {
        this.addDependent(this.endNode, this.getNode(dependent));
        return dependent;
    }

    public <L extends LifecycleUser<T>> L appendDependent(L newSoleEndDependent) {
        Node<T> soleEndDependency = this.endNode;
        this.endNode = new Node();
        soleEndDependency.setContent(newSoleEndDependent);
        this.addContentNode(newSoleEndDependent, soleEndDependency);
        soleEndDependency.addDependency(this.endNode);
        this.lastDependent = soleEndDependency;
        this.lastDependency = this.endNode;
        return newSoleEndDependent;
    }

    public <L extends LifecycleUser<T>> L prependDependency(L newSoleRootDependency) {
        Node<T> soleRootDependency = this.rootNode;
        this.rootNode = new Node();
        soleRootDependency.setContent(newSoleRootDependency);
        this.addContentNode(newSoleRootDependency, soleRootDependency);
        this.rootNode.addDependency(soleRootDependency);
        this.lastDependent = this.rootNode;
        this.lastDependency = soleRootDependency;
        return newSoleRootDependency;
    }

    public <L extends LifecycleUser<T>> L chainConcurrentDependency(L dependency) {
        this.addDependency(this.lastDependent, this.getNode(dependency));
        return dependency;
    }

    public <L extends LifecycleUser<T>> L chainConcurrentDependent(L dependent) {
        this.addDependent(this.lastDependency, this.getNode(dependent));
        return dependent;
    }

    public <L extends LifecycleUser<T>> L chainConcurrentSibling(L sibling) {
        Node<T> siblingNode = this.getNode(sibling);
        Node<T> lastDependencyLocal = this.lastDependency;
        this.addDependency(this.lastDependent, siblingNode);
        this.addDependent(lastDependencyLocal, siblingNode);
        return sibling;
    }

    public static <R extends JobParameters> Transformation<R> repeat(final int count, final BiConsumer<Transformation<R>, LifecycleUser<R>> consumer, final Supplier<LifecycleUser<R>> generator) {
        return new Transformation<R>(){
            {
                for (int i = 0; i < count; ++i) {
                    consumer.accept(this, (LifecycleUser)generator.get());
                }
            }
        };
    }

    public static <R extends JobParameters> Transformation<R> repeatSequential(int count, Supplier<LifecycleUser<R>> generator) {
        return Transformation.repeat(count, Transformation::chainDependent, generator);
    }

    public static <R extends JobParameters> Transformation<R> repeatParallel(int count, Supplier<LifecycleUser<R>> generator) {
        return Transformation.repeat(count, Transformation::addEndDependent, generator);
    }
}

