/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.core;

import io.github.douira.glsl_transformer.core.CachePolicy;
import io.github.douira.glsl_transformer.core.CachingSupplier;
import io.github.douira.glsl_transformer.core.ValueSupplier;
import io.github.douira.glsl_transformer.transform.JobParameters;
import io.github.douira.glsl_transformer.transform.Transformation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Supplier;

public class ConfigurableTransformation<T extends JobParameters>
extends Transformation<T> {
    private Collection<CachingSupplier<?>> cachingSuppliers = new LinkedList();
    private T lastJobParameters;

    protected <V> Supplier<V> swapSupplier(Supplier<V> currentSupplier, Supplier<V> newSupplier) {
        if (currentSupplier != newSupplier) {
            this.removeSupplier(currentSupplier);
        }
        return this.addSupplier(newSupplier);
    }

    protected <V> Supplier<V> swapSupplier(Supplier<V> currentSupplier, V newValue) {
        return this.swapSupplier(currentSupplier, (V)new ValueSupplier<V>(newValue));
    }

    protected void removeSupplier(Supplier<?> currentSupplier) {
        if (currentSupplier == null) {
            throw new IllegalStateException("The current supplier is null!");
        }
        if (CachingSupplier.class.isInstance(currentSupplier)) {
            this.cachingSuppliers.remove((CachingSupplier)currentSupplier);
        }
    }

    protected <V> Supplier<V> addSupplier(Supplier<V> supplier) {
        if (supplier == null) {
            throw new IllegalStateException("The new supplier is null!");
        }
        if (CachingSupplier.class.isInstance(supplier)) {
            this.cachingSuppliers.remove((CachingSupplier)supplier);
        }
        return supplier;
    }

    protected <V> Supplier<V> swapPolicy(Supplier<V> currentSupplier, CachePolicy newPolicy) {
        if (CachingSupplier.class.isInstance(currentSupplier)) {
            return this.swapSupplier(currentSupplier, (V)((CachingSupplier)currentSupplier).getSupplierWithPolicy(newPolicy));
        }
        return this.cachingSupplier(newPolicy, currentSupplier);
    }

    protected <V> Supplier<V> cachingSupplier(CachePolicy cachePolicy, Supplier<V> newSupplier) {
        return this.addSupplier(CachingSupplier.of(cachePolicy, newSupplier));
    }

    protected <V> Supplier<V> value(V newValue) {
        return new ValueSupplier<V>(newValue);
    }

    protected <V> Supplier<V> once(Supplier<V> supplier) {
        return this.swapPolicy(supplier, CachePolicy.ONCE);
    }

    private void invalidateCachingSuppliers(CachePolicy fulfilledPolicy) {
        for (CachingSupplier<?> supplier : this.cachingSuppliers) {
            supplier.invalidate(fulfilledPolicy);
        }
    }

    @Override
    protected void triggerJobInternal() {
        Object newJobParameters = this.getJobParameters();
        if (this.lastJobParameters == null || !((JobParameters)this.lastJobParameters).equals((JobParameters)newJobParameters)) {
            this.invalidateCachingSuppliers(CachePolicy.ON_FIXED_PARAMETER_CHANGE);
            this.lastJobParameters = newJobParameters;
        } else {
            this.invalidateCachingSuppliers(CachePolicy.ON_JOB);
        }
    }
}

